% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean2}
\alias{ci.mean2}
\title{Confidence interval for a 2-group mean difference}
\usage{
ci.mean2(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean difference
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes equal variance and unequal variance confidence intervals for a
population 2-group mean difference using the estimated means, estimated
standard deviations, and sample sizes. Also computes equal variance and
unequal variance independent-samples t-tests. Use the t.test function for
raw data input.

For more details, see Section 2.3 of Bonett (2021, Volume 1)
}
\examples{
ci.mean2(.05, 19.4, 11.3, 2.70, 2.10, 40, 40)
# Should return:
#                              Estimate        SE       t    df p
# Equal Variances Assumed:          8.1 0.5408327 14.9769 78.00 0
# Equal Variances Not Assumed:      8.1 0.5408327 14.9769 73.54 0
#                                    LL       UL
# Equal Variances Assumed:     7.023285 9.176715
# Equal Variances Not Assumed: 7.022256 9.177744


}
\references{
\insertRef{Snedecor1980}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
