% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean.fpc}
\alias{ci.mean.fpc}
\title{Confidence interval for a mean with a finite population correction}
\usage{
ci.mean.fpc(alpha, m, sd, n, N)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{estimated mean}

\item{sd}{estimated standard deviation}

\item{n}{sample size}

\item{N}{population size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean
\item SE - standard error with fpc
\item LL - lower limit of the confidence interval with fpc
\item UL - upper limit of the confidence interval with fpc
}
}
\description{
Computes a confidence interval for a population mean with a finite
population correction (fpc) using the estimated mean, estimated standard
deviation, sample size, and population size. This function is useful when
the sample size is not a small fraction of the population size.

For more details, see Section 1.33 of Bonett (2021, Volume 1)
}
\examples{
ci.mean.fpc(.05, 24.5, 3.65, 40, 300)

# Should return:
# Estimate        SE       LL       UL
#     24.5 0.5381631 23.41146 25.58854
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
