% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.icc}
\alias{ci.icc}
\title{Confidence interval for an intraclass reliablity coefficient}
\usage{
ci.icc(alpha, MSr, MSe, r, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{MSr}{mean square for rows}

\item{MSe}{error mean square}

\item{r}{number of measurements (items, raters, forms)}

\item{n}{sample size}
}
\value{
Returns a 2-row matrix. The first row results are for ICC(C, 1) and
the second row results are for ICC(C, r). The columns are:
\itemize{
\item Estimate - estimated reliability
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population intraclass reliability
coefficient using mean squared estimates from a two-way ANOVA. This
function will compute point and interval estimates of the ICC(C, 1) and
ICC(C, r) reliability coefficients where ICC(C, 1) is the reliability of
a single measurements (e.g., a single rater or a single form of a test)
and ICC(C, r) is the reliability of a sum or average of r measurements.
ICC(C, r) is the same as Cronbach's reliability coefficient. The
ci.cronbach function uses a point estimate of Cronbach's reliability
as input. The confidence intervals used in this function assume parallel
measurements which implies a compound symmetric covariance matrix of
the r measurements.
}
\examples{
ci.icc(.05, 48.2, 11.3, 5, 30)

# Should return:
#           Estimate      SE     LL     UL
# ICC(C, 1)   0.3951 0.09166 0.2311 0.5853
# ICC(C, r)   0.7656 0.07005 0.6005 0.8759
 

}
\references{
\insertRef{McGraw1996}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
