% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.bayes.prop}
\alias{ci.bayes.prop}
\title{Bayesian credible interval for a proportion}
\usage{
ci.bayes.prop(alpha, prior_mean, prior_sd, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha credibility interval}

\item{prior_mean}{mean of prior Beta distribution}

\item{prior_sd}{standard deviation of prior Beta distribution}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Posterior mean - posterior mean of Beta distribution
\item Posterior SD - posterior standard deviation of Beta distribution
\item LL - lower limit of the credible interval
\item UL - upper limit of the credible interval
}
}
\description{
Computes a Bayesian credible interval for a population proportion using the
mean and standard deviation of a prior Beta distribution along with sample
information. The mean and standard deviation of the posterior Beta
distribution are also reported. For a noninformative prior, set the prior
mean to .5 and the prior standard deviation to 1/sqrt(12) (which
corresponds to a Beta(1,1) distribution). The prior variance must be
less than m(1 - m) where m is the prior mean.

For more details, see Section 1.18 of Bonett (2021, Volume 3)
}
\examples{
ci.bayes.prop(.05, .25, .1, 120, 300)

# Should return:
# Posterior mean Posterior SD        LL        UL
#      0.3916208   0.02742595 0.3387206 0.4458133


}
\references{
\insertRef{Gelman2004}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
