% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{sp_get_dataset}
\alias{sp_get_dataset}
\title{Retrieve dataset from statnipokladna}
\usage{
sp_get_dataset(
  dataset_id,
  year,
  month = 12,
  dest_dir = NULL,
  redownload = FALSE
)
}
\arguments{
\item{dataset_id}{A dataset ID. See \code{id} column in \code{sp_datasets} for a list of available datasets}

\item{year}{year, numeric vector of length <= 1 (can take multiple values), 2015-2019 for some datasets, 2010-2020 for others. Defaults to 2018.
(see Details for how to work with data across time periods.)}

\item{month}{month, numeric vector of length <= 1 (can take multiple values). Must be between 1 and 12. Defaults to 12.
(see Details for how to work with data across time periods.)}

\item{dest_dir}{character. Directory in which downloaded files will be stored.
If left unset, will use the \code{statnipokladna.dest_dir} option if the option is set, and \code{tempdir()} otherwise. Will be created if it does not exist.}

\item{redownload}{Redownload even if file has already been downloaded? Defaults to FALSE.}
}
\value{
character string with complete paths to downloaded ZIP archives.
}
\description{
Downloads ZIP archives for a given dataset. If \code{year} or \code{month} have length > 1, gets all combinations.
}
\details{
Files are stored in a temp folder as determined by \code{tempdir()} or the \code{dest_dir} param or the \code{statnipokladna.dest_dir} option.
and further sorted into subdirectories by dataset, year and month. If saved to \code{tempdir()} (the default), downloaded files per session to avoid redownloads.

How data for different time periods is exported differs by dataset.
This has significant implications for how you get to usable full-year numbers or time series in different tables.
See \code{vignette("statnipokladna")} for details on this.
}
\examples{
\dontrun{
budget_2018 <- sp_get_dataset("finm", 2018)
budget_mid2018 <- sp_get_dataset("finm", 2018, 6)
}
}
\seealso{
Other Core workflow: 
\code{\link{sp_add_codelist}()},
\code{\link{sp_get_codelist}()},
\code{\link{sp_get_table}()}
}
\concept{Core workflow}
