% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win_prob.R
\name{win_prob}
\alias{win_prob}
\title{Calculates the probability of winning}
\source{
\doi{10.1161/STROKEAHA.121.037744}
}
\usage{
win_prob(
  data,
  response = NULL,
  group = NULL,
  alpha = 0.05,
  beta = 0.2,
  group.ratio = 1,
  sample.size = FALSE,
  print.tables = FALSE,
  dec = 3
)
}
\arguments{
\item{data}{A data frame containing the response and group variable.}

\item{response}{The name of the response variable.
Takes first column if empty.}

\item{group}{The name of the group variable.
Takes second column if empty.}

\item{alpha}{The alpha level for the hypothesis test. Default is 0.05.}

\item{beta}{The beta level for the sample size calculation. Default is 0.2.}

\item{group.ratio}{The ratio of group sizes. Default is 1.}

\item{sample.size}{Flag to include sample size calculation. Default is FALSE.}

\item{print.tables}{Flag to print cumulative tables. Default is FALSE.}

\item{dec}{Numeric for decimals to print. Default is 3.}
}
\value{
A list containing the win_prob statistics.
}
\description{
Calculates the probability of winning (winP). In the referenced
article Zou et al (2022) proposes a method for calculating probability of
winning with a confidence interval an p-value testing.
}
\examples{
win_prob(data=stRoke::talos,response="mrs_6",group="rtreat")
}
