% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_node_colours.R
\name{update_node_colours}
\alias{update_node_colours}
\title{Update Node Colours in an Event Tree}
\usage{
update_node_colours(
  event_tree_obj,
  node_groups,
  colours,
  level_separation = 1000,
  node_distance = 300
)
}
\arguments{
\item{event_tree_obj}{A list containing the event tree object (possibly with node deletion). It should include:
\itemize{
\item \verb{$eventtree$x$nodes}: A data frame of nodes.
\item \verb{$eventtree$x$edges}: A data frame of edges.
\item \verb{$filtereddf}: A filtered data frame associated with the event tree.
}}

\item{node_groups}{A list of character vectors, where each vector contains node IDs belonging to a specific group.}

\item{colours}{A character vector of colour codes corresponding to each node group. The length of \code{colours} must match \code{node_groups}.}

\item{level_separation}{Numeric value specifying the spacing between levels in the hierarchical layout.
Default is \code{1000}.}

\item{node_distance}{Numeric value specifying the distance between nodes in the layout.
Default is \code{300}.}
}
\value{
A list containing:
\itemize{
\item \verb{$stagedtree}: A \code{visNetwork} object representing the updated event tree with coloured nodes.
\item \verb{$filtereddf}: The filtered data frame, returned invisibly.
}
}
\description{
This function updates the colours of nodes in an event tree based on user-defined
groups while ensuring that nodes with the same colour have consistent outgoing edge labels.
}
\details{
The function follows these steps:
\itemize{
\item Assigns colours to nodes based on the specified \code{node_groups}.
\item Ensures that no node appears in multiple groups (raises an error if duplicates exist).
\item Checks that all nodes with the same colour have identical outgoing edge labels.
\item Updates the event tree visualization using \code{visNetwork}.
}
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
event_tree

# Define node groups and colours
node_groups <- list(c("s1", "s2"), c("s3", "s4"))
colours <- c("#BBA0CA", "#8AC6D0")

# Apply colours to the event tree
coloured_tree <- update_node_colours(event_tree, node_groups, colours)
coloured_tree

}
