% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_basic_plots.R
\name{cens_lines_plot}
\alias{cens_lines_plot}
\title{Graphical representation of censored data}
\usage{
cens_lines_plot(
  data,
  unit,
  logscale,
  fits = NULL,
  leftNA = 0,
  rightNA = Inf,
  color_group = FALSE
)
}
\arguments{
\item{data}{A data.frame containing censored toxicity values. It must have
columns \code{left}, \code{right}, and \code{label} if \code{color_group =
TRUE}. Censored values are indicated with \code{NA}.}

\item{unit}{A character vector, the unit of the toxicity data}

\item{logscale}{if \code{TRUE}, uses a logarithmic scale for the \eqn{x}-axis}

\item{fits}{A list of fits of class \code{fitdist} or \code{fitdistcens}
computed from the same toxicity data.}

\item{leftNA}{The value to replace censored left values. Default to 0 because
toxicity values are concentrations.}

\item{rightNA}{The value to replace censored right values.}

\item{color_group}{if \code{TRUE}, color the elements of the plot by the
group label of the data (column \code{label}).}
}
\value{
A ggplot object.
}
\description{
\code{cens_lines_plot} create a plot representing each interval of toxicity
values with a horizontal line, or a point if the bounds of the interval are
equal. It is possible to color the lines by a grouping indicator.
}
