// Generated by rstantools.  Do not edit by hand.

/*
    ssMousetrack is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ssMousetrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ssMousetrack.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_simulate_data_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 122> locations_array__ =
  {" (found before start of program)",
  " (in 'simulate_data', line 51, column 2 to column 19)",
  " (in 'simulate_data', line 54, column 2 to column 16)",
  " (in 'simulate_data', line 72, column 2 to column 23)",
  " (in 'simulate_data', line 73, column 2 to column 26)",
  " (in 'simulate_data', line 74, column 2 to column 29)",
  " (in 'simulate_data', line 75, column 2 to column 30)",
  " (in 'simulate_data', line 76, column 2 to column 20)",
  " (in 'simulate_data', line 77, column 2 to column 30)",
  " (in 'simulate_data', line 55, column 2 to column 14)",
  " (in 'simulate_data', line 79, column 2 to column 29)",
  " (in 'simulate_data', line 82, column 6 to column 46)",
  " (in 'simulate_data', line 81, column 17 to line 83, column 5)",
  " (in 'simulate_data', line 81, column 4 to line 83, column 5)",
  " (in 'simulate_data', line 80, column 15 to line 84, column 3)",
  " (in 'simulate_data', line 80, column 2 to line 84, column 3)",
  " (in 'simulate_data', line 94, column 6 to column 47)",
  " (in 'simulate_data', line 95, column 6 to column 61)",
  " (in 'simulate_data', line 96, column 6 to column 53)",
  " (in 'simulate_data', line 97, column 6 to column 81)",
  " (in 'simulate_data', line 93, column 9 to line 98, column 5)",
  " (in 'simulate_data', line 90, column 6 to column 37)",
  " (in 'simulate_data', line 91, column 6 to column 53)",
  " (in 'simulate_data', line 92, column 6 to column 43)",
  " (in 'simulate_data', line 89, column 12 to line 93, column 5)",
  " (in 'simulate_data', line 89, column 4 to line 98, column 5)",
  " (in 'simulate_data', line 100, column 6 to column 54)",
  " (in 'simulate_data', line 99, column 4 to line 100, column 54)",
  " (in 'simulate_data', line 87, column 15 to line 102, column 3)",
  " (in 'simulate_data', line 87, column 2 to line 102, column 3)",
  " (in 'simulate_data', line 68, column 35 to column 93)",
  " (in 'simulate_data', line 68, column 9 to column 93)",
  " (in 'simulate_data', line 67, column 35 to column 92)",
  " (in 'simulate_data', line 67, column 9 to line 68, column 93)",
  " (in 'simulate_data', line 66, column 35 to column 91)",
  " (in 'simulate_data', line 66, column 9 to line 68, column 93)",
  " (in 'simulate_data', line 65, column 35 to column 81)",
  " (in 'simulate_data', line 65, column 9 to line 68, column 93)",
  " (in 'simulate_data', line 64, column 35 to column 77)",
  " (in 'simulate_data', line 64, column 9 to line 68, column 93)",
  " (in 'simulate_data', line 63, column 37 to column 134)",
  " (in 'simulate_data', line 63, column 114 to column 132)",
  " (in 'simulate_data', line 63, column 95 to column 113)",
  " (in 'simulate_data', line 63, column 9 to line 68, column 93)",
  " (in 'simulate_data', line 62, column 35 to column 92)",
  " (in 'simulate_data', line 62, column 9 to line 68, column 93)",
  " (in 'simulate_data', line 61, column 30 to column 90)",
  " (in 'simulate_data', line 61, column 4 to line 68, column 93)",
  " (in 'simulate_data', line 60, column 16 to line 69, column 3)",
  " (in 'simulate_data', line 60, column 2 to line 69, column 3)",
  " (in 'simulate_data', line 34, column 2 to column 8)",
  " (in 'simulate_data', line 35, column 2 to column 8)",
  " (in 'simulate_data', line 36, column 2 to column 8)",
  " (in 'simulate_data', line 37, column 2 to column 9)",
  " (in 'simulate_data', line 38, column 8 to column 9)",
  " (in 'simulate_data', line 38, column 18 to column 21)",
  " (in 'simulate_data', line 38, column 2 to column 25)",
  " (in 'simulate_data', line 39, column 18 to column 19)",
  " (in 'simulate_data', line 39, column 2 to column 28)",
  " (in 'simulate_data', line 40, column 29 to column 32)",
  " (in 'simulate_data', line 40, column 2 to column 41)",
  " (in 'simulate_data', line 41, column 9 to column 12)",
  " (in 'simulate_data', line 41, column 13 to column 15)",
  " (in 'simulate_data', line 41, column 2 to column 19)",
  " (in 'simulate_data', line 42, column 18 to column 21)",
  " (in 'simulate_data', line 42, column 2 to column 34)",
  " (in 'simulate_data', line 43, column 9 to column 11)",
  " (in 'simulate_data', line 43, column 2 to column 29)",
  " (in 'simulate_data', line 44, column 2 to column 10)",
  " (in 'simulate_data', line 45, column 2 to column 10)",
  " (in 'simulate_data', line 46, column 2 to column 10)",
  " (in 'simulate_data', line 47, column 2 to column 25)",
  " (in 'simulate_data', line 48, column 2 to column 25)",
  " (in 'simulate_data', line 51, column 9 to column 11)",
  " (in 'simulate_data', line 54, column 9 to column 12)",
  " (in 'simulate_data', line 72, column 8 to column 9)",
  " (in 'simulate_data', line 72, column 18 to column 19)",
  " (in 'simulate_data', line 73, column 8 to column 9)",
  " (in 'simulate_data', line 73, column 18 to column 21)",
  " (in 'simulate_data', line 74, column 8 to column 9)",
  " (in 'simulate_data', line 74, column 18 to column 21)",
  " (in 'simulate_data', line 75, column 8 to column 9)",
  " (in 'simulate_data', line 75, column 18 to column 21)",
  " (in 'simulate_data', line 76, column 9 to column 12)",
  " (in 'simulate_data', line 77, column 8 to column 9)",
  " (in 'simulate_data', line 77, column 18 to column 21)",
  " (in 'simulate_data', line 3, column 11 to column 12)",
  " (in 'simulate_data', line 3, column 13 to column 14)",
  " (in 'simulate_data', line 3, column 4 to column 18)",
  " (in 'simulate_data', line 4, column 11 to column 14)",
  " (in 'simulate_data', line 4, column 4 to column 22)",
  " (in 'simulate_data', line 6, column 6 to column 36)",
  " (in 'simulate_data', line 5, column 17 to line 6, column 37)",
  " (in 'simulate_data', line 5, column 4 to line 6, column 37)",
  " (in 'simulate_data', line 7, column 4 to column 26)",
  " (in 'simulate_data', line 8, column 4 to column 17)",
  " (in 'simulate_data', line 2, column 53 to line 9, column 3)",
  " (in 'simulate_data', line 11, column 11 to column 12)",
  " (in 'simulate_data', line 11, column 13 to column 14)",
  " (in 'simulate_data', line 11, column 4 to column 18)",
  " (in 'simulate_data', line 12, column 11 to column 14)",
  " (in 'simulate_data', line 12, column 4 to column 22)",
  " (in 'simulate_data', line 14, column 6 to column 30)",
  " (in 'simulate_data', line 13, column 17 to line 14, column 31)",
  " (in 'simulate_data', line 13, column 4 to line 14, column 31)",
  " (in 'simulate_data', line 15, column 4 to column 26)",
  " (in 'simulate_data', line 16, column 4 to column 17)",
  " (in 'simulate_data', line 10, column 55 to line 17, column 3)",
  " (in 'simulate_data', line 19, column 4 to column 20)",
  " (in 'simulate_data', line 20, column 4 to column 25)",
  " (in 'simulate_data', line 21, column 4 to column 25)",
  " (in 'simulate_data', line 22, column 4 to column 107)",
  " (in 'simulate_data', line 18, column 55 to line 23, column 3)",
  " (in 'simulate_data', line 26, column 11 to column 12)",
  " (in 'simulate_data', line 26, column 4 to column 17)",
  " (in 'simulate_data', line 29, column 11 to column 32)",
  " (in 'simulate_data', line 28, column 18 to column 39)",
  " (in 'simulate_data', line 28, column 6 to line 29, column 32)",
  " (in 'simulate_data', line 27, column 17 to line 29, column 33)",
  " (in 'simulate_data', line 27, column 4 to line 29, column 33)",
  " (in 'simulate_data', line 30, column 4 to column 14)",
  " (in 'simulate_data', line 25, column 67 to line 31, column 3)"};
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_J(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__);
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_I(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__>,-1,1>
rescale_data(const T0__& x_arg__, const T1__& min_x, const T2__& max_x,
             std::ostream* pstream__);
template <typename T0__, typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T2__, T3__, T4__>,-1,1>
compute_deltay(const T0__& x_arg__, const int& I, const T2__& pT, const T3__&
               pD, const T4__& pC, std::ostream* pstream__);
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_J(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 86;
    stan::math::validate_non_negative_index("X", "I", I);
    current_statement__ = 87;
    stan::math::validate_non_negative_index("X", "J", J);
    Eigen::Matrix<local_scalar_t__,-1,-1> X =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(I, J, DUMMY_VAR__);
    current_statement__ = 89;
    stan::math::validate_non_negative_index("x_vec", "I * J", (I * J));
    Eigen::Matrix<local_scalar_t__,-1,1> x_vec =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((I * J), DUMMY_VAR__);
    current_statement__ = 93;
    for (int i = 1; i <= I; ++i) {
      current_statement__ = 91;
      stan::model::assign(X,
        stan::math::rep_row_vector(
          stan::model::rvalue(x, "x", stan::model::index_uni(i)), J),
        "assigning variable X", stan::model::index_uni(i));
    }
    current_statement__ = 94;
    stan::model::assign(x_vec,
      stan::math::to_vector(stan::math::transpose(X)),
      "assigning variable x_vec");
    current_statement__ = 95;
    return x_vec;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_I(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 97;
    stan::math::validate_non_negative_index("X", "I", I);
    current_statement__ = 98;
    stan::math::validate_non_negative_index("X", "J", J);
    Eigen::Matrix<local_scalar_t__,-1,-1> X =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(I, J, DUMMY_VAR__);
    current_statement__ = 100;
    stan::math::validate_non_negative_index("x_vec", "I * J", (I * J));
    Eigen::Matrix<local_scalar_t__,-1,1> x_vec =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((I * J), DUMMY_VAR__);
    current_statement__ = 104;
    for (int i = 1; i <= I; ++i) {
      current_statement__ = 102;
      stan::model::assign(X, stan::math::to_row_vector(x),
        "assigning variable X", stan::model::index_uni(i));
    }
    current_statement__ = 105;
    stan::model::assign(x_vec,
      stan::math::to_vector(stan::math::transpose(X)),
      "assigning variable x_vec");
    current_statement__ = 106;
    return x_vec;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__>,-1,1>
rescale_data(const T0__& x_arg__, const T1__& min_x, const T2__& max_x,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__, T2__>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int I = std::numeric_limits<int>::min();
    current_statement__ = 108;
    I = stan::math::rows(x);
    local_scalar_t__ max_Vx = DUMMY_VAR__;
    current_statement__ = 109;
    max_Vx = stan::math::max(x);
    local_scalar_t__ min_Vx = DUMMY_VAR__;
    current_statement__ = 110;
    min_Vx = stan::math::min(x);
    current_statement__ = 111;
    return stan::math::add(stan::math::rep_vector(min_x, I),
             stan::math::elt_multiply(
               stan::math::elt_divide(stan::math::subtract(x, min_Vx),
                 stan::math::rep_vector((max_Vx - min_Vx), I)),
               stan::math::rep_vector((max_x - min_x), I)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T2__, T3__, T4__>,-1,1>
compute_deltay(const T0__& x_arg__, const int& I, const T2__& pT, const T3__&
               pD, const T4__& pC, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T2__, T3__, T4__>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 113;
    stan::math::validate_non_negative_index("dx", "I", I);
    Eigen::Matrix<local_scalar_t__,-1,1> dx =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(I, DUMMY_VAR__);
    current_statement__ = 119;
    for (int i = 1; i <= I; ++i) {
      current_statement__ = 117;
      if (stan::math::logical_gt(
            stan::model::rvalue(x, "x", stan::model::index_uni(i)), pC)) {
        current_statement__ = 116;
        stan::model::assign(dx,
          stan::math::abs(
            (stan::model::rvalue(x, "x", stan::model::index_uni(i)) - pD)),
          "assigning variable dx", stan::model::index_uni(i));
      } else {
        current_statement__ = 115;
        stan::model::assign(dx,
          stan::math::abs(
            (stan::model::rvalue(x, "x", stan::model::index_uni(i)) - pT)),
          "assigning variable dx", stan::model::index_uni(i));
      }
    }
    current_statement__ = 120;
    return dx;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_simulate_data final : public model_base_crtp<model_simulate_data> {
private:
  int I;
  int N;
  int J;
  int KK;
  std::vector<Eigen::Matrix<double,-1,1>> Y;
  Eigen::Matrix<double,-1,1> sigmaz_data__;
  Eigen::Matrix<double,-1,-1> bnds_data__;
  Eigen::Matrix<double,-1,-1> D_data__;
  Eigen::Matrix<double,-1,1> lambda_vec_data__;
  Eigen::Matrix<double,-1,-1> priors_matrix_data__;
  double pT;
  double pD;
  double pC;
  double kappa_lb;
  double kappa_ub;
  int b_1dim__;
  int mu_2dim__;
  int y_sim_2dim__;
  int dy_sim_2dim__;
  int z_vec_1dim__;
  int kappas_2dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> sigmaz{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> bnds{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> D{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> lambda_vec{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> priors_matrix{nullptr, 0, 0};
public:
  ~model_simulate_data() {}
  model_simulate_data(stan::io::var_context& context__, unsigned int
                      random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_simulate_data_namespace::model_simulate_data";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 50;
      context__.validate_dims("data initialization", "I", "int",
        std::vector<size_t>{});
      I = std::numeric_limits<int>::min();
      current_statement__ = 50;
      I = context__.vals_i("I")[(1 - 1)];
      current_statement__ = 51;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 51;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 52;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 52;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 53;
      context__.validate_dims("data initialization", "KK", "int",
        std::vector<size_t>{});
      KK = std::numeric_limits<int>::min();
      current_statement__ = 53;
      KK = context__.vals_i("KK")[(1 - 1)];
      current_statement__ = 54;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("Y", "I * J", (I * J));
      current_statement__ = 56;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N),
          static_cast<size_t>((I * J))});
      Y = std::vector<Eigen::Matrix<double,-1,1>>(N,
            Eigen::Matrix<double,-1,1>::Constant((I * J),
              std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 56;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= (I * J); ++sym1__) {
          current_statement__ = 56;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 56;
            stan::model::assign(Y, Y_flat__[(pos__ - 1)],
              "assigning variable Y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 56;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 57;
      stan::math::validate_non_negative_index("sigmaz", "I", I);
      current_statement__ = 58;
      context__.validate_dims("data initialization", "sigmaz", "double",
        std::vector<size_t>{static_cast<size_t>(I)});
      sigmaz_data__ = Eigen::Matrix<double,-1,1>::Constant(I,
                        std::numeric_limits<double>::quiet_NaN());
      new (&sigmaz)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sigmaz_data__.data(), I);
      {
        std::vector<local_scalar_t__> sigmaz_flat__;
        current_statement__ = 58;
        sigmaz_flat__ = context__.vals_r("sigmaz");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          current_statement__ = 58;
          stan::model::assign(sigmaz, sigmaz_flat__[(pos__ - 1)],
            "assigning variable sigmaz", stan::model::index_uni(sym1__));
          current_statement__ = 58;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 58;
      stan::math::check_greater_or_equal(function__, "sigmaz", sigmaz, 0);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("bnds", "I * J", (I * J));
      current_statement__ = 60;
      context__.validate_dims("data initialization", "bnds", "double",
        std::vector<size_t>{static_cast<size_t>((I * J)),
          static_cast<size_t>(3)});
      bnds_data__ = Eigen::Matrix<double,-1,-1>::Constant((I * J), 3,
                      std::numeric_limits<double>::quiet_NaN());
      new (&bnds) Eigen::Map<Eigen::Matrix<double,-1,-1>>(bnds_data__.data(),
        (I * J), 3);
      {
        std::vector<local_scalar_t__> bnds_flat__;
        current_statement__ = 60;
        bnds_flat__ = context__.vals_r("bnds");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 60;
          for (int sym2__ = 1; sym2__ <= (I * J); ++sym2__) {
            current_statement__ = 60;
            stan::model::assign(bnds, bnds_flat__[(pos__ - 1)],
              "assigning variable bnds", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 60;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 60;
      stan::math::check_greater_or_equal(function__, "bnds", bnds, 0);
      current_statement__ = 60;
      stan::math::check_less_or_equal(function__, "bnds", bnds,
        stan::math::pi());
      current_statement__ = 61;
      stan::math::validate_non_negative_index("D", "I * J", (I * J));
      current_statement__ = 62;
      stan::math::validate_non_negative_index("D", "KK", KK);
      current_statement__ = 63;
      context__.validate_dims("data initialization", "D", "double",
        std::vector<size_t>{static_cast<size_t>((I * J)),
          static_cast<size_t>(KK)});
      D_data__ = Eigen::Matrix<double,-1,-1>::Constant((I * J), KK,
                   std::numeric_limits<double>::quiet_NaN());
      new (&D) Eigen::Map<Eigen::Matrix<double,-1,-1>>(D_data__.data(), (I *
        J), KK);
      {
        std::vector<local_scalar_t__> D_flat__;
        current_statement__ = 63;
        D_flat__ = context__.vals_r("D");
        current_statement__ = 63;
        pos__ = 1;
        current_statement__ = 63;
        for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
          current_statement__ = 63;
          for (int sym2__ = 1; sym2__ <= (I * J); ++sym2__) {
            current_statement__ = 63;
            stan::model::assign(D, D_flat__[(pos__ - 1)],
              "assigning variable D", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 63;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 64;
      stan::math::validate_non_negative_index("lambda_vec", "I * J", (I * J));
      current_statement__ = 65;
      context__.validate_dims("data initialization", "lambda_vec", "double",
        std::vector<size_t>{static_cast<size_t>((I * J))});
      lambda_vec_data__ = Eigen::Matrix<double,-1,1>::Constant((I * J),
                            std::numeric_limits<double>::quiet_NaN());
      new (&lambda_vec)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(lambda_vec_data__.data(), (I *
        J));
      {
        std::vector<local_scalar_t__> lambda_vec_flat__;
        current_statement__ = 65;
        lambda_vec_flat__ = context__.vals_r("lambda_vec");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= (I * J); ++sym1__) {
          current_statement__ = 65;
          stan::model::assign(lambda_vec, lambda_vec_flat__[(pos__ - 1)],
            "assigning variable lambda_vec", stan::model::index_uni(sym1__));
          current_statement__ = 65;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "lambda_vec",
        lambda_vec, 0);
      current_statement__ = 66;
      stan::math::validate_non_negative_index("priors_matrix", "KK", KK);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "priors_matrix",
        "double",
        std::vector<size_t>{static_cast<size_t>(KK), static_cast<size_t>(5)});
      priors_matrix_data__ = Eigen::Matrix<double,-1,-1>::Constant(KK, 5,
                               std::numeric_limits<double>::quiet_NaN());
      new (&priors_matrix)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(priors_matrix_data__.data(),
        KK, 5);
      {
        std::vector<local_scalar_t__> priors_matrix_flat__;
        current_statement__ = 67;
        priors_matrix_flat__ = context__.vals_r("priors_matrix");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= 5; ++sym1__) {
          current_statement__ = 67;
          for (int sym2__ = 1; sym2__ <= KK; ++sym2__) {
            current_statement__ = 67;
            stan::model::assign(priors_matrix, priors_matrix_flat__[(pos__ -
              1)], "assigning variable priors_matrix",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 67;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 68;
      context__.validate_dims("data initialization", "pT", "double",
        std::vector<size_t>{});
      pT = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 68;
      pT = context__.vals_r("pT")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization", "pD", "double",
        std::vector<size_t>{});
      pD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 69;
      pD = context__.vals_r("pD")[(1 - 1)];
      current_statement__ = 70;
      context__.validate_dims("data initialization", "pC", "double",
        std::vector<size_t>{});
      pC = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 70;
      pC = context__.vals_r("pC")[(1 - 1)];
      current_statement__ = 71;
      context__.validate_dims("data initialization", "kappa_lb", "double",
        std::vector<size_t>{});
      kappa_lb = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 71;
      kappa_lb = context__.vals_r("kappa_lb")[(1 - 1)];
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "kappa_lb", kappa_lb, 0);
      current_statement__ = 72;
      context__.validate_dims("data initialization", "kappa_ub", "double",
        std::vector<size_t>{});
      kappa_ub = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 72;
      kappa_ub = context__.vals_r("kappa_ub")[(1 - 1)];
      current_statement__ = 72;
      stan::math::check_greater_or_equal(function__, "kappa_ub", kappa_ub, 0);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("gamma", "KK", KK);
      current_statement__ = 74;
      b_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 74;
      b_1dim__ = (I * J);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("b", "I * J", b_1dim__);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("z", "N", N);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("z", "I", I);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("mu", "N", N);
      current_statement__ = 78;
      mu_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 78;
      mu_2dim__ = (I * J);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("mu", "I * J", mu_2dim__);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("y_sim", "N", N);
      current_statement__ = 80;
      y_sim_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 80;
      y_sim_2dim__ = (I * J);
      current_statement__ = 80;
      stan::math::validate_non_negative_index("y_sim", "I * J", y_sim_2dim__);
      current_statement__ = 81;
      stan::math::validate_non_negative_index("dy_sim", "N", N);
      current_statement__ = 82;
      dy_sim_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 82;
      dy_sim_2dim__ = (I * J);
      current_statement__ = 82;
      stan::math::validate_non_negative_index("dy_sim", "I * J",
        dy_sim_2dim__);
      current_statement__ = 83;
      z_vec_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 83;
      z_vec_1dim__ = (I * J);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("z_vec", "I * J", z_vec_1dim__);
      current_statement__ = 84;
      stan::math::validate_non_negative_index("kappas", "N", N);
      current_statement__ = 85;
      kappas_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 85;
      kappas_2dim__ = (I * J);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("kappas", "I * J",
        kappas_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = KK;
  }
  inline std::string model_name() const final {
    return "model_simulate_data";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_simulate_data_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(KK, DUMMY_VAR__);
      current_statement__ = 1;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(KK);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(b_1dim__, DUMMY_VAR__);
      current_statement__ = 9;
      stan::model::assign(b, stan::math::multiply(D, gamma),
        "assigning variable b");
      {
        current_statement__ = 49;
        for (int k = 1; k <= KK; ++k) {
          current_statement__ = 47;
          if (stan::math::logical_eq(
                stan::model::rvalue(priors_matrix, "priors_matrix",
                  stan::model::index_uni(k), stan::model::index_uni(1)), 1)) {
            current_statement__ = 46;
            lp_accum__.add(stan::math::lognormal_lpdf<propto__>(
                             stan::model::rvalue(gamma, "gamma",
                               stan::model::index_uni(k)),
                             stan::model::rvalue(priors_matrix,
                               "priors_matrix", stan::model::index_uni(k),
                               stan::model::index_uni(2)),
                             stan::model::rvalue(priors_matrix,
                               "priors_matrix", stan::model::index_uni(k),
                               stan::model::index_uni(3))));
          } else {
            current_statement__ = 45;
            if (stan::math::logical_eq(
                  stan::model::rvalue(priors_matrix, "priors_matrix",
                    stan::model::index_uni(k), stan::model::index_uni(1)), 2)) {
              current_statement__ = 44;
              lp_accum__.add(stan::math::normal_lpdf<propto__>(
                               stan::model::rvalue(gamma, "gamma",
                                 stan::model::index_uni(k)),
                               stan::model::rvalue(priors_matrix,
                                 "priors_matrix", stan::model::index_uni(k),
                                 stan::model::index_uni(2)),
                               stan::model::rvalue(priors_matrix,
                                 "priors_matrix", stan::model::index_uni(k),
                                 stan::model::index_uni(3))));
            } else {
              current_statement__ = 43;
              if (stan::math::logical_eq(
                    stan::model::rvalue(priors_matrix, "priors_matrix",
                      stan::model::index_uni(k), stan::model::index_uni(1)),
                    201)) {
                current_statement__ = 40;
                lp_accum__.add(stan::math::normal_lpdf<propto__>(
                                 stan::model::rvalue(gamma, "gamma",
                                   stan::model::index_uni(k)),
                                 stan::model::rvalue(priors_matrix,
                                   "priors_matrix",
                                   stan::model::index_uni(k),
                                   stan::model::index_uni(2)),
                                 stan::model::rvalue(priors_matrix,
                                   "priors_matrix",
                                   stan::model::index_uni(k),
                                   stan::model::index_uni(3))));
                current_statement__ = 42;
                if (stan::math::logical_lt(
                      stan::model::rvalue(gamma, "gamma",
                        stan::model::index_uni(k)),
                      stan::model::rvalue(priors_matrix, "priors_matrix",
                        stan::model::index_uni(k), stan::model::index_uni(4)))) {
                  current_statement__ = 42;
                  lp_accum__.add(stan::math::negative_infinity());
                } else {
                  current_statement__ = 41;
                  if (stan::math::logical_gt(
                        stan::model::rvalue(gamma, "gamma",
                          stan::model::index_uni(k)),
                        stan::model::rvalue(priors_matrix, "priors_matrix",
                          stan::model::index_uni(k),
                          stan::model::index_uni(5)))) {
                    current_statement__ = 41;
                    lp_accum__.add(stan::math::negative_infinity());
                  } else {
                    current_statement__ = 41;
                    lp_accum__.add(-stan::math::log_diff_exp(
                                      stan::math::normal_lcdf(
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(5)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(2)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(3))),
                                      stan::math::normal_lcdf(
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(4)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(2)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(3)))));
                  }
                }
              } else {
                current_statement__ = 39;
                if (stan::math::logical_eq(
                      stan::model::rvalue(priors_matrix, "priors_matrix",
                        stan::model::index_uni(k), stan::model::index_uni(1)),
                      3)) {
                  current_statement__ = 38;
                  lp_accum__.add(stan::math::chi_square_lpdf<propto__>(
                                   stan::model::rvalue(gamma, "gamma",
                                     stan::model::index_uni(k)),
                                   stan::model::rvalue(priors_matrix,
                                     "priors_matrix",
                                     stan::model::index_uni(k),
                                     stan::model::index_uni(2))));
                } else {
                  current_statement__ = 37;
                  if (stan::math::logical_eq(
                        stan::model::rvalue(priors_matrix, "priors_matrix",
                          stan::model::index_uni(k),
                          stan::model::index_uni(1)), 4)) {
                    current_statement__ = 36;
                    lp_accum__.add(stan::math::inv_chi_square_lpdf<propto__>(
                                     stan::model::rvalue(gamma, "gamma",
                                       stan::model::index_uni(k)),
                                     stan::model::rvalue(priors_matrix,
                                       "priors_matrix",
                                       stan::model::index_uni(k),
                                       stan::model::index_uni(2))));
                  } else {
                    current_statement__ = 35;
                    if (stan::math::logical_eq(
                          stan::model::rvalue(priors_matrix, "priors_matrix",
                            stan::model::index_uni(k),
                            stan::model::index_uni(1)), 5)) {
                      current_statement__ = 34;
                      lp_accum__.add(stan::math::gamma_lpdf<propto__>(
                                       stan::model::rvalue(gamma, "gamma",
                                         stan::model::index_uni(k)),
                                       stan::model::rvalue(priors_matrix,
                                         "priors_matrix",
                                         stan::model::index_uni(k),
                                         stan::model::index_uni(2)),
                                       stan::model::rvalue(priors_matrix,
                                         "priors_matrix",
                                         stan::model::index_uni(k),
                                         stan::model::index_uni(3))));
                    } else {
                      current_statement__ = 33;
                      if (stan::math::logical_eq(
                            stan::model::rvalue(priors_matrix,
                              "priors_matrix", stan::model::index_uni(k),
                              stan::model::index_uni(1)), 6)) {
                        current_statement__ = 32;
                        lp_accum__.add(stan::math::pareto_lpdf<propto__>(
                                         stan::model::rvalue(gamma, "gamma",
                                           stan::model::index_uni(k)),
                                         stan::model::rvalue(priors_matrix,
                                           "priors_matrix",
                                           stan::model::index_uni(k),
                                           stan::model::index_uni(2)),
                                         stan::model::rvalue(priors_matrix,
                                           "priors_matrix",
                                           stan::model::index_uni(k),
                                           stan::model::index_uni(3))));
                      } else {
                        current_statement__ = 31;
                        if (stan::math::logical_eq(
                              stan::model::rvalue(priors_matrix,
                                "priors_matrix", stan::model::index_uni(k),
                                stan::model::index_uni(1)), 7)) {
                          current_statement__ = 30;
                          lp_accum__.add(stan::math::uniform_lpdf<propto__>(
                                           stan::model::rvalue(gamma,
                                             "gamma",
                                             stan::model::index_uni(k)),
                                           stan::model::rvalue(priors_matrix,
                                             "priors_matrix",
                                             stan::model::index_uni(k),
                                             stan::model::index_uni(2)),
                                           stan::model::rvalue(priors_matrix,
                                             "priors_matrix",
                                             stan::model::index_uni(k),
                                             stan::model::index_uni(3))));
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_simulate_data_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> gamma =
        Eigen::Matrix<double,-1,1>::Constant(KK,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(KK);
      Eigen::Matrix<double,-1,1> b =
        Eigen::Matrix<double,-1,1>::Constant(b_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(gamma);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 9;
      stan::model::assign(b, stan::math::multiply(D, gamma),
        "assigning variable b");
      if (emit_transformed_parameters__) {
        out__.write(b);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<Eigen::Matrix<double,-1,1>> z =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(I,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> mu =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(mu_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> y_sim =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(y_sim_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> dy_sim =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(dy_sim_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      Eigen::Matrix<double,-1,1> z_vec =
        Eigen::Matrix<double,-1,1>::Constant(z_vec_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<Eigen::Matrix<double,-1,1>> kappas =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(kappas_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 10;
      stan::model::assign(z, stan::math::rep_vector(1e-04, I),
        "assigning variable z", stan::model::index_uni(1));
      current_statement__ = 15;
      for (int n = 2; n <= N; ++n) {
        current_statement__ = 13;
        for (int i = 1; i <= I; ++i) {
          current_statement__ = 11;
          stan::model::assign(z,
            stan::math::normal_rng(
              stan::model::rvalue(z, "z", stan::model::index_uni((n - 1)),
                stan::model::index_uni(i)),
              stan::model::rvalue(sigmaz, "sigmaz", stan::model::index_uni(i)),
              base_rng__), "assigning variable z", stan::model::index_uni(n),
            stan::model::index_uni(i));
        }
      }
      current_statement__ = 29;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 25;
        if (stan::math::logical_eq(n, 1)) {
          current_statement__ = 21;
          stan::model::assign(mu,
            stan::math::rep_vector((stan::math::pi() / 2), (I * J)),
            "assigning variable mu", stan::model::index_uni(n));
          current_statement__ = 22;
          stan::model::assign(dy_sim,
            compute_deltay(
              stan::model::rvalue(mu, "mu", stan::model::index_uni(n)), (I *
              J), pT, pD, pC, pstream__), "assigning variable dy_sim",
            stan::model::index_uni(n));
          current_statement__ = 23;
          stan::model::assign(kappas,
            stan::math::rep_vector(kappa_ub, (I * J)),
            "assigning variable kappas", stan::model::index_uni(n));
        } else {
          current_statement__ = 16;
          stan::model::assign(z_vec,
            kronecker_simplified_J(I, J,
              stan::model::rvalue(z, "z", stan::model::index_uni(n)),
              pstream__), "assigning variable z_vec");
          current_statement__ = 17;
          stan::model::assign(mu,
            stan::math::add(
              stan::model::rvalue(bnds, "bnds", stan::model::index_omni(),
                stan::model::index_uni(1)),
              stan::math::elt_divide(
                stan::model::rvalue(bnds, "bnds", stan::model::index_omni(),
                  stan::model::index_uni(3)),
                stan::math::add(1,
                  stan::math::exp(stan::math::subtract(b, z_vec))))),
            "assigning variable mu", stan::model::index_uni(n));
          current_statement__ = 18;
          stan::model::assign(dy_sim,
            compute_deltay(
              stan::model::rvalue(mu, "mu", stan::model::index_uni(n)), (I *
              J), pT, pD, pC, pstream__), "assigning variable dy_sim",
            stan::model::index_uni(n));
          current_statement__ = 19;
          stan::model::assign(kappas,
            rescale_data(
              stan::math::exp(
                stan::math::elt_multiply(lambda_vec,
                  stan::model::rvalue(dy_sim, "dy_sim",
                    stan::model::index_uni(n)))), kappa_lb, kappa_ub,
              pstream__), "assigning variable kappas",
            stan::model::index_uni(n));
        }
        current_statement__ = 27;
        for (int q = 1; q <= (I * J); ++q) {
          current_statement__ = 26;
          stan::model::assign(y_sim,
            stan::math::von_mises_rng(
              stan::model::rvalue(mu, "mu", stan::model::index_uni(n),
                stan::model::index_uni(q)),
              stan::model::rvalue(kappas, "kappas",
                stan::model::index_uni(n), stan::model::index_uni(q)),
              base_rng__), "assigning variable y_sim",
            stan::model::index_uni(n), stan::model::index_uni(q));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(z[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(mu[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= y_sim_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(y_sim[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= dy_sim_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(dy_sim[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(z_vec);
      for (int sym1__ = 1; sym1__ <= kappas_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(kappas[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(KK, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(gamma,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(KK),
        "assigning variable gamma");
      out__.write(gamma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "gamma", "double",
        std::vector<size_t>{static_cast<size_t>(KK)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(KK, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        gamma_flat__ = context__.vals_r("gamma");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(gamma, gamma_flat__[(pos__ - 1)],
            "assigning variable gamma", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(gamma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"gamma"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"b"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"z", "mu", "y_sim", "dy_sim", "z_vec", "kappas"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    KK)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(b_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(I)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(mu_2dim__)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(y_sim_2dim__)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(dy_sim_2dim__)},
             std::vector<size_t>{static_cast<size_t>(z_vec_1dim__)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(kappas_2dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= b_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "z" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "mu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= y_sim_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "y_sim" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= dy_sim_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "dy_sim" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= z_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "z_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= kappas_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "kappas" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= b_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "z" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "mu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= y_sim_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "y_sim" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= dy_sim_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "dy_sim" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= z_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "z_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= kappas_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "kappas" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(KK) + "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(b_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(mu_2dim__) + "}},\"block\":\"generated_quantities\"},{\"name\":\"y_sim\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_sim_2dim__) + "}},\"block\":\"generated_quantities\"},{\"name\":\"dy_sim\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(dy_sim_2dim__) + "}},\"block\":\"generated_quantities\"},{\"name\":\"z_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(z_vec_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"kappas\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(kappas_2dim__) + "}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(KK) + "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(b_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"z\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(mu_2dim__) + "}},\"block\":\"generated_quantities\"},{\"name\":\"y_sim\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_sim_2dim__) + "}},\"block\":\"generated_quantities\"},{\"name\":\"dy_sim\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(dy_sim_2dim__) + "}},\"block\":\"generated_quantities\"},{\"name\":\"z_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(z_vec_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"kappas\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(kappas_2dim__) + "}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = KK;
    const size_t num_transformed = emit_transformed_parameters * (b_1dim__);
    const size_t num_gen_quantities = emit_generated_quantities * (((((((N *
      I) + (N * mu_2dim__)) + (N * y_sim_2dim__)) + (N * dy_sim_2dim__)) +
      z_vec_1dim__) + (N * kappas_2dim__)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = KK;
    const size_t num_transformed = emit_transformed_parameters * (b_1dim__);
    const size_t num_gen_quantities = emit_generated_quantities * (((((((N *
      I) + (N * mu_2dim__)) + (N * y_sim_2dim__)) + (N * dy_sim_2dim__)) +
      z_vec_1dim__) + (N * kappas_2dim__)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_simulate_data_namespace::model_simulate_data;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_simulate_data_namespace::profiles__;
}
#endif
#endif
