% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgs_test.R
\name{pkgs_test}
\alias{pkgs_test}
\title{tests a list of source packages}
\usage{
pkgs_test(
  pkgids = names(filter_srcpkgs(src_pkgs, filter)),
  src_pkgs = get_srcpkgs(),
  filter = NULL,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{pkgids}{a list of package ids (names, paths or object), or a
srcpkgs object. Also accept a singleton package object}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{filter}{filter out the packages to test using this pattern}

\item{quiet}{whether to be quiet/silent}

\item{...}{passed to \code{pkg_test}}
}
\value{
the results as a \code{pkgs_test} object
}
\description{
tests a list of source packages
}
\examples{
## create a dummy collection of srcpkgs by replicating the dummy srcpkg
 pkg <- setup_and_get_dummy_srcpkg()
 pkgs <- srcpkgs(list(pkg, pkg))

 res <- pkgs_test(pkgs, error_on = "never")
 print(res)
}
