% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{sqlq-package}
\alias{sqlq}
\alias{sqlq-package}
\title{sqlq: 'SQL' Query Builder}
\description{
Allows to build complex 'SQL' (Structured Query Language) queries dynamically. Classes and/or factory functions are used to produce a syntax tree from which the final character string is generated. Strings and identifiers are automatically quoted using the right quotes, using either ANSI (American National Standards Institute) quoting or the quoting style of an existing database connector. Style can be configured to set uppercase/lowercase for keywords, remove unnecessary spaces, or omit optional keywords.
}
\details{
\emph{sqlq} package.

\emph{sqlq} simplifies the creation of SQL queries, and ensure identifiers and
string values are correctly quoted.

Global options used by \emph{sqlq}:
\itemize{
\item sqlq_always_quote: If set to TRUE, token identifiers (table and column
names) will always be quoted.
\item sqlq_conn: Set the database connector to use for quoting identifiers and
values. Default is DBI::ANSI().
\item sqlq_omit_kwd: If set to TRUE, optional SQL keywords (like INNER or OUTER)
will be omitted.
\item sqlq_spaces: If set to FALSE, try to avoid non-necessary spaces (e.g.:
around operators or after a comma).
\item sqlq_uppercase: If set to FALSE, SQL keywords and alphabetical operators
(e.g.: OR, AND, ...) will be written in lowercase.
}
}
\examples{

options(sqlq_uppercase = FALSE)

}
\seealso{
\link{options}.
}
\author{
\strong{Maintainer}: Pierrick Roger \email{pierrick.roger@cea.fr} (\href{https://orcid.org/0000-0001-8177-4873}{ORCID})

}
