% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_related_artists}
\alias{get_related_artists}
\title{Get Spotify catalog information about artists similar to a given artist.
Similarity is based on analysis of the Spotify community’s listening history.}
\usage{
get_related_artists(
  id,
  authorization = get_spotify_access_token(),
  include_meta_info = FALSE
)
}
\arguments{
\item{id}{The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the artist.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing artist data. See \url{https://developer.spotify.com/documentation/web-api/reference/artists/get-several-artists/} for more information.
}
\description{
Get Spotify catalog information about artists similar to a given artist.
Similarity is based on analysis of the Spotify community’s listening history.
}
\seealso{
Other artist functions: 
\code{\link{get_artist}()},
\code{\link{get_artist_albums}()},
\code{\link{get_artist_top_tracks}()},
\code{\link{get_artists}()},
\code{\link{get_my_followed_artists}()}
}
\concept{artist functions}
