% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-lacrosse.R
\name{geom_lacrosse}
\alias{geom_lacrosse}
\title{Draw Lacrosse Field}
\usage{
geom_lacrosse(
  league,
  display_range = "full",
  field_updates = list(),
  color_updates = list(),
  rotation = 0,
  x_trans = 0,
  y_trans = 0,
  field_units = NULL,
  xlims = NULL,
  ylims = NULL
)
}
\arguments{
\item{league}{The league for which to draw the surface. This is
case-insensitive}

\item{display_range}{A case-insensitive string indicating the display range
to use for the plot. The default is \code{"full"}, which will be returned
when either an invalid or no value is passed to the function.

The possible display ranges are:
\describe{
\item{\code{"full"}}{
The full field. This is the default
}
\item{\code{"offense"}}{
The offensive half of the field. This is the right half of the field
in TV view
}
\item{\code{"offence"}}{
The offensive half of the field. This is the right half of the field
in TV view
}
\item{\code{"offensivehalffield"}}{
The offensive half of the field. This is the right half of the field
in TV view
}
\item{\code{"offensive_half_field"}}{
The offensive half of the field. This is the right half of the field
in TV view
}
\item{\code{"offensive half field"}}{
The offensive half of the field. This is the right half of the field
in TV view
}
\item{\code{"defense"}}{
The defensive half of the field. This is the left half of the field in
TV view
}
\item{\code{"defence"}}{
The defensive half of the field. This is the left half of the field in
TV view
}
\item{\code{"defensivehalffield"}}{
The defensive half of the field. This is the left half of the field in
TV view
}
\item{\code{"defensive_half_field"}}{
The defensive half of the field. This is the left half of the field in
TV view
}
\item{\code{"defensive half field"}}{
The defensive half of the field. This is the left half of the field in
TV view
}
}}

\item{field_updates}{A list of updates to the fields' parameters. These will
overwrite the parameters of the league}

\item{color_updates}{A list of updates to the fields' default colors, which
are set by \code{\link[=lacrosse_features_set_colors]{lacrosse_features_set_colors()}}}

\item{rotation}{An angle, given in degrees, through which the plot should be
rotated}

\item{x_trans}{The amount that the \code{x} coordinates are to be shifted. By
convention, the +\code{x} axis extends from the center of the field towards
the right-hand basket when viewing the field in TV View}

\item{y_trans}{The amount that the \code{y} coordinates are to be shifted. By
convention, the +\code{y} axis extends from the center of the field towards
the top of the field when viewing the field in TV view}

\item{field_units}{The units with which to draw the field. The default is
\code{NULL}, which will apply the rule-book specified units}

\item{xlims}{The limits on the final display in the \code{x} direction. The
default is \code{NULL}, which will utilize the \code{xlims} specified by
the \code{display_range} parameter}

\item{ylims}{The limits on the final display in the \code{y} direction. The
default is \code{NULL}, which will utilize the \code{ylims} specified by
the \code{display_range} parameter}
}
\value{
A \code{ggplot2} instance with a full-surface representation of a
lacrosse field
}
\description{
Generate a \code{ggplot2} instance containing a lacrosse field for a
specified league
}
\examples{
\dontrun{
  geom_lacrosse(league = "NCAA", rotation = 270, display_range = "offense")
  geom_lacrosse(league = "FIVB", field_units = "ft")
}
}
