% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncs_analysis.R
\docType{class}
\name{splinetrials_analysis-class}
\alias{splinetrials_analysis-class}
\title{\code{splinetrials_analysis} object}
\description{
\code{\link[=ncs_analysis]{ncs_analysis()}} returns an object of class \code{splinetrials_analysis}: a 32-column
\code{\link[dplyr:reexports]{tibble}} with one row per unique combination of
\code{data[[arm]]} and \code{data[[time_scheduled_label]]} (see the arguments of
\code{\link[=ncs_analysis]{ncs_analysis()}}).
}
\section{Columns}{
\enumerate{
\item \code{arm}: values of \code{data[[arm]]}.
\item \code{time}: values of \code{data[[time_scheduled_label]]}.
\item \code{n}: number of times the combination appears in data.
\item \code{est}: \link{mean} of \code{data[[response]]}.
\item \code{sd}: \link[=sd]{standard deviation} of \code{data[[response]]}.
\item \code{se}: standard error of \code{data[[response]]} (i.e., \code{sd / sqrt(n)}).
\item \code{lower}: lower bound of confidence interval.
\item \code{upper}: upper bound of confidence interval.
\item \code{response_est}: estimated marginal mean.
\item \code{response_se}: standard error of \code{response_est}.
\item \code{response_df}: degrees of freedom used for calculating the confidence
interval for \code{response_est}.
\item \code{response_lower}: lower bound of confidence interval for \code{response_est}.
\item \code{response_upper}: upper bound of confidence interval for \code{response_est}.
\item \code{change_est}: estimated change from baseline.
\item \code{change_se}: standard error of \code{change_est}.
\item \code{change_df}: degrees of freedom used for calculating the confidence
interval for and testing the significance of \code{change_est}.
\item \code{change_lower}: lower bound of confidence interval for \code{change_est}.
\item \code{change_upper}: upper bound of confidence interval for \code{change_est}.
\item \code{change_test_statistic}: test statistic measuring the significance of
\code{change_est}.
\item \code{change_p_value}: p-value for the significance of \code{change_est}.
\item \code{diff_est}: treatment effect.
\item \code{diff_se}: standard error of \code{diff_est}.
\item \code{diff_df}: degrees of freedom used for calculating the confidence interval
for and testing the significance of \code{diff_est}.
\item \code{diff_lower}: lower bound of confidence interval for \code{diff_est}.
\item \code{diff_upper}: upper bound of confidence interval for \code{diff_est}.
\item \code{diff_test_statistic}: test statistic measuring the significance of
\code{diff_est}.
\item \code{diff_p_value}: p-value for the significance of \code{diff_est}.
\item \code{percent_slowing_est}: estimated percent slowing.
\item \code{percent_slowing_lower}: lower bound of confidence interval for
\code{percent_slowing_est}.
\item \code{percent_slowing_upper}: upper bound of confidence interval for
\code{percent_slowing_est}.
\item \code{correlation}: the covariance structure of the analysis model. This is the
same value repeated for each row.
\item \code{optimizer}: invariably \code{mmrm+tmb} to indicate that \code{\link[mmrm:mmrm]{mmrm::mmrm()}} (which
uses the \code{TMB} package) was used to fit the model.
}
}

\section{Optional \code{analysis_model} attribute}{
If \code{\link[=ncs_analysis]{ncs_analysis()}} had \code{return_models = TRUE}, then the analysis model, an
\code{mmrm} object, will be included as the \code{analysis_model} \link{attr}ibute.
}

\seealso{
The function \code{\link[=ncs_analysis]{ncs_analysis()}}, which produces objects of this
class.
}
