% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slidingWindow.R
\name{slidingWindow}
\alias{slidingWindow}
\title{Create windows along an alignment}
\usage{
slidingWindow(DNAbin, width, interval = 1)
}
\arguments{
\item{DNAbin}{A DNA alignment of class `DNAbin'.}

\item{width}{Width of each window.}

\item{interval}{Numeric or option of \code{"codons"}. This sets interval
between windows. Default of 1. Setting the option to "codons" gives an
interval of 3.}
}
\value{
A list of `DNAbin' objects, with each alignment being \code{width}
bases in length. The list has length of the DNA alignment minus the width.
The positions covered by each window can be retrieved with \code{attr(x,
"window")}.
}
\description{
Creates windows of a specified width along a DNA alignment.
}
\details{
Sliding window analyses are often used to determine the variability along
sequences. This can be useful for investigating whether there is evidence
for recombination, developing shorter genetic markers, or for determining
variation within a gene.

Analyses can be conducted on each window using \code{\link{lapply}}.
}
\examples{

data(woodmouse)
woodmouse <- woodmouse[,1:20]
win1 <- slidingWindow(woodmouse, width = 10)
length(win1)

win2 <- slidingWindow(woodmouse, width = 10, interval = 2)
length(win2)

win3 <- slidingWindow(woodmouse, width = 10, interval = "codons")
length(win3)

win4 <- slidingWindow(woodmouse, width = 15)
length(win4)
attr(win4[[1]], "window")
attr(win4[[2]], "window")

}
\seealso{
\code{\link{lapply}}, \code{\link{slideAnalyses}},
\code{\link{slideBoxplots}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Sliding}
\keyword{window}
