% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{darEsSalaam}
\alias{darEsSalaam}
\title{Comparative Judgment on Deprivation in Dar es Salaam, Tanzania}
\format{
A list with three elements.
The first is a dataframe containing the comparison. Each row corresponds
to a judgement made by a single judge. Columns 2 and 3 contain the pair of s
ubwards being compared. The first column shows the outcome
of the comparison: 1 if player 2 won, 2 if it was a tie and 0 if player 1 won
(although there a no instances of this happening). This differs from the data
in the \code{BSBT} package as it explicitly includes ties rather than randomly
allocating a winner.

The second is a dataframe containing the names and shapefiles of the subwards

The third is an adjacency matrix of the subwards formed from the shapefiles.
This considers subwards as nodes and places edges between adjacent subwards.
Two additional edges have been manually included to allow for crossings of the
Kurasini creek.
}
\source{
This data set was collected by Madeleine Ellis, James Goulding, Bertrand Perrat,
Gavin Smith and Gregor Engelmann. We gratefully acknowledge the Rights Lab at the
University of Nottingham for supporting funding for the comprehensive ground truth survey.
We also acknowledge HumanitarianStreet Mapping Team (HOT) for providing a team of experts in
data collection to facilitate the surveys. This work was also supported by the EPSRC Horizon
Centre for Doctoral Training - My Life in Data (EP/L015463/1) and EPSRC grant
Neodemographics (EP/L021080/1).
}
\usage{
darEsSalaam
}
\description{
A comparative judgment data set on deprivation in subwards in Dar es Salaam,
Tanzania.Citizens were shown pairs of subwards at random and asked which
was more deprived.If they said they were equal, one of the pair was chosen at
random to be more deprived.The data was collected in August 2018.
The sex of each judge is also included.
}
\keyword{datasets}
