% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tuning.R
\name{plot_tuning}
\alias{plot_tuning}
\title{Plots a tuning object produced by \code{\link[=rf_tuning]{rf_tuning()}}}
\usage{
plot_tuning(
  model,
  point.color = viridis::viridis(
    100,
    option = "F"
  ),
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf_tuning]{rf_tuning()}}. Default: \code{NULL}}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F")}}

\item{verbose}{Logical, if \code{TRUE}, the plot is printed. Default: \code{TRUE}}
}
\value{
A ggplot.
}
\description{
Plots the tuning of the hyperparameters \code{num.trees}, \code{mtry}, and \code{min.node.size} performed by \code{\link[=rf_tuning]{rf_tuning()}}.
}
\examples{

if(interactive()){
  data(
    plants_rf,
    plants_xy
  )

  plants_rf_tuned <- rf_tuning(
    model = plants_rf,
    num.trees = c(25, 50),
    mtry = c(5, 10),
    min.node.size = c(10, 20),
    xy = plants_xy,
    repetitions = 5,
    n.cores = 1
  )

  plot_tuning(plants_rf_tuned)
}

}
\seealso{
\code{\link[=rf_tuning]{rf_tuning()}}

Other visualization: 
\code{\link{plot_evaluation}()},
\code{\link{plot_importance}()},
\code{\link{plot_moran}()},
\code{\link{plot_optimization}()},
\code{\link{plot_residuals_diagnostics}()},
\code{\link{plot_response_curves}()},
\code{\link{plot_response_surface}()},
\code{\link{plot_training_df}()},
\code{\link{plot_training_df_moran}()}
}
\concept{visualization}
