% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jitter_power.R
\name{jitter_power}
\alias{jitter_power}
\title{Power of SRR function for previously collected data.}
\usage{
jitter_power(
  obs_data,
  sim_total = 2,
  samp_control = c("uniform", "CSR", "MVN"),
  s_control = 1,
  alpha = 0.05,
  p_correct = "none",
  parallel = FALSE,
  n_core = 2,
  verbose = TRUE,
  ...,
  cascon = lifecycle::deprecated(),
  lower_tail = lifecycle::deprecated(),
  upper_tail = lifecycle::deprecated()
)
}
\arguments{
\item{obs_data}{A bivariate point pattern (a multitype point pattern of object of class "ppp") with two types of points in a factor valued mark.}

\item{sim_total}{Integer, specifying the number of simulation iterations to perform.}

\item{samp_control}{Character string specifying whether to randomize the control locations uniformly (\code{samp_control="uniform"}), with complete spatial randomness (\code{samp_control="CSR"}), or multivariate normal (\code{samp_control="MVN"}).}

\item{s_control}{Optional. Numeric value for the standard deviation of the multivariate normal distribution in the units of the \code{obs_data}. The default value (1) assumes a unit square window. Ignored if Ignored if \code{samp_control="uniform"} or \code{samp_control="CSR"}.}

\item{alpha}{Optional. Numeric value of the critical p-value (default=0.05).}

\item{p_correct}{Optional. Character string specifying whether to apply a correction for multiple comparisons including a False Discovery Rate \code{p_correct = "FDR"}, a Sidak correction \code{p_correct = "uncorrelated Sidak"}, and a Bonferroni correction \code{p_correct = "uncorrelated Bonferroni"}. If \code{p_correct = "none"} (the default), then no correction is applied.}

\item{parallel}{Logical. If TRUE, will execute the function in parallel. If FALSE (the default), will not execute the function in parallel.}

\item{n_core}{Optional. Integer specifying the number of CPU cores on current host to use for parallelization (the default is 2 cores).}

\item{verbose}{Logical. If TRUE (the default), will print function progress during execution. If FALSE, will not print.}

\item{...}{Arguments passed to \code{\link[sparr]{risk}} to select bandwidth, edge correction, and resolution.}

\item{cascon}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{cascon} is no longer supported and this function will output power for case-only and case/control clustering. This argument has been moved to \code{spatial_plots} function.}

\item{lower_tail}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{lower_tail} is no longer supported; this function uses \code{alpha} to set the critical p-value.}

\item{upper_tail}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{upper_tail} is no longer supported; this function uses \code{alpha} to set the critical p-value.}
}
\value{
An object of class "list". This is a named list with the following components:

\describe{
\item{\code{sim}}{An object of class 'rrs' for the first iteration of simulated data.}
\item{\code{out}}{An object of class 'rrs' for the observed spatial relative risk function without randomization.}
\item{\code{rr_mean}}{Vector of length \code{[resolution x resolution]} of the mean relative risk values at each gridded knot.}
\item{\code{pval_mean}}{Vector of length \code{[resolution x resolution]} of the mean asymptotic p-value at each gridded knot.}
\item{\code{rr_sd}}{Vector of length \code{[resolution x resolution]} of the standard deviation of relative risk values at each gridded knot.}
\item{\code{pval_prop_cascon}}{Vector of length \code{[resolution x resolution]} of the proportion of asymptotic p-values that were significant for both case and control locations at each gridded knot.}
\item{\code{pval_prop_cas}}{Vector of length \code{[resolution x resolution]} of the proportion of asymptotic p-values that were significant for only case locations at each gridded knot.}
\item{\code{rx}}{Vector of length \code{[resolution x resolution]} of the x-coordinates of each gridded knot.}
\item{\code{ry}}{Vector of length \code{[resolution x resolution]} of the y-coordinates of each gridded knot.}
\item{\code{n_cas}}{Vector of length \code{sim_total} of the number of case locations simulated in each iteration.}
\item{\code{n_con}}{Vector of length \code{sim_total} of the number of control locations simulated in each iteration.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the bandwidth (of numerator) used in each iteration.}
\item{\code{s_obs}}{Vector of length \code{sim_total} of the global s statistic.}
\item{\code{t_obs}}{Vector of length \code{sim_total} of the global t statistic.}
\item{\code{alpha}}{Vector of length \code{sim_total} of the (un)corrected critical p-values.}
}
}
\description{
Compute the statistical power of a spatial relative risk function using previously collected data.
}
\details{
This function computes the statistical power of the spatial relative risk function (nonparametric estimate of relative risk by kernel smoothing) for previously collected studies with known case and control locations.

The function uses the \code{\link[sparr]{risk}} function to estimate the spatial relative risk function and forces the \code{tolerate} argument to be TRUE in order to calculate asymptotic p-values.

If \code{samp_control = "uniform"} the control locations are randomly generated uniformly within the dow of \code{obs_data}. By default, the resolution is an integer value of 128 and can be specified using the \code{resolution} argument in the internally called \code{\link[sparr]{risk}} function.

If \code{samp_control = "CSR"} the control locations are randomly generated assuming complete spatial randomness (homogeneous Poisson process) within the dow of \code{obs_data} with a \code{lambda = number of controls / [resolution x resolution]}. By default, the resolution is an integer value of 128 and can be specified using the \code{resolution} argument in the internally called \code{\link[sparr]{risk}} function.

If \code{samp_control = "MVN"} the control locations are randomly generated assuming a multivariate normal distribution \emph{centered at each observed location}. The optional argument \code{s_control} specifies the standard deviation of the multivariate normal distribution (1 by default) in the units of the \code{obs_data}.

The function computes a one-sided hypothesis test for case clustering (\code{alpha = 0.05} by default). The function also computes a two-sided hypothesis test for case clustering and control clustering (lower tail = 0.025 and upper tail = 0.975).

The function has functionality for a correction for multiple testing. If \code{p_correct = "FDR"}, calculates a False Discovery Rate by Benjamini and Hochberg. If \code{p_correct = "Sidak"}, calculates a Sidak correction. If \code{p_correct = "Bonferroni"}, calculates a Bonferroni correction. If \code{p_correct = "none"} (the default), then the function does not account for multiple testing and uses the uncorrected \code{alpha} level. See the internal \code{pval_correct} function documentation for more details.
}
\examples{
# Using the 'chorley' data set from 'spatstat.data' package
 data(chorley, package="spatstat.data")
 f1 <- jitter_power(obs_data = unique(chorley),
                    samp_control = "CSR",
                    verbose = FALSE)

}
\seealso{
\code{\link[sparr]{risk}} for additional arguments for bandwidth selection, edge correction, and resolution.
}
