% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer.R
\name{transfer}
\alias{transfer}
\title{Transfer (food, contaminant) across trophic levels}
\usage{
transfer(
  spacemodel,
  kernels,
  intakes = NULL,
  exposure_weighting = "local",
  verbose = FALSE
)
}
\arguments{
\item{spacemodel}{A named list of spatial layers (e.g. \code{SpatRaster} objects).
Must contain an attribute \code{trophic_tbl} of class \code{trophic_tbl}.}

\item{kernels}{A list of kernel parameters for each layer.}

\item{intakes}{A \code{trophic_tbl} object (or compatible table) containing
normalized weights and flux functions for each trophic link.}

\item{exposure_weighting}{Character. Defines how the realized exposure is calculated
based on the predator's presence. Options are:
\itemize{
  \item \code{"local"} (Default): Weight exposure by the local habitat value (`predator_habitat`).
  Assumes the predator's intake is strictly proportional to the habitat quality/density
  of the pixel where it resides.
  \item \code{"diffuse"}: Weight exposure by a dispersed habitat kernel.
  Represents a "neighborhood" effect where the predator's presence is smoothed
  over its home range. Useful to avoid edge effects where a predator on a poor pixel
  surrounded by good habitat would otherwise have 0 exposure.
  \item \code{"potential"}: No weighting. Returns the pure environmental offer (potential exposure)
  regardless of the predator's density. Useful for identifying risk hotspots.
}}

\item{verbose}{Logical. If \code{TRUE}, prints progress information.}
}
\value{
A named `spacemodel` object as a list of spatial layers representing
 values after transfer.
}
\description{
Computes the transfer through a trophic network from
lower to higher trophic levels using spatial spreading and intake functions.
}
\details{
The function processes layers in ascending trophic order, as defined
by the \code{level} attribute of the trophic table.

For each layer:
\enumerate{
  \item Resources (lower neighbors) are identified.
  \item Concentration from each resource is spatially spread using \code{spread()}.
  \item Intake is computed using \code{intake()}.
  \item Contributions from all resources are summed.
}

The function assumes that intake weights are already normalized so that,
for each consumer, the sum of contributions from all resources equals 1.
}
