% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departements.R
\name{get_departements_for_roi}
\alias{get_departements_for_roi}
\title{Identify codes of departments intersecting a region of interest}
\usage{
get_departements_for_roi(roi)
}
\arguments{
\item{roi}{A spatial object of type `sf` or `sfc` representing the region of interest.
Use only the first geometry (polygon).}
}
\value{
A character vector containing the codes of departments intersecting the region of interest.
}
\description{
This function takes a region of interest (ROI) as an `sf` or `sfc` object
and returns the codes of departments intersecting this region.
}
\examples{
library(sf)
roi <- sf::st_as_sfc(sf::st_bbox(
  c(xmin = 600000, ymin = 6600000, xmax = 650000, ymax = 6650000),
  crs = 2154)
)
departments <- get_departements_for_roi(roi)
}
