% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_scalewise.R
\name{sp_scalewise}
\alias{sp_scalewise}
\title{Extract scale-wise spatial processes}
\usage{
sp_scalewise(mod, bw_range = c(0, Inf))
}
\arguments{
\item{mod}{Output object from the \code{cf_lm} function.}

\item{bw_range}{Range of bandwidth values of the simulated spatial processes.
For example, if bw_range = c(10, 20), spatial processes with bandwidths
between 10 and 20 are synthesized and simulated. The default is c(0, Inf),
which synthesizes all scales.}
}
\value{
A list with the following elements:
\describe{
  \item{pred}{Means and standard deviations of the spatial process (sample sites).}
  \item{pred0}{Means and standard deviations of the spatial process (prediction sites).}
}
}
\description{
Evaluate mean and variance of the spatial process with bandwidth values
within a pre-specified range
}
\seealso{
\code{\link{cf_lm}}
}
\author{
Daisuke Murakami
}
