% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_list.R
\name{update_rank_list}
\alias{update_rank_list}
\title{Change the text or labels of a rank list.}
\usage{
update_rank_list(
  css_id,
  text = NULL,
  labels = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{css_id}{This is the css id to use, and must be unique in your shiny
app. This defaults to the value of \code{input_id}, and will be appended to the
value "rank-list-container", to ensure the CSS id is unique for the
container as well as the labels.
If NULL, the function generates an id of the form
\code{rank_list_id_1}, and will automatically increment for every \code{rank_list}.}

\item{text}{Text to appear at top of list.}

\item{labels}{A character vector with the text to display inside the widget.
This can also be a list of html tag elements.  The text content of each
label or label name will be used to set the shiny \code{input_id} value.
To create an empty \code{rank_list}, use \code{labels = list()}.}

\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}
}
\description{
Change the text or labels of a rank list.
}
\examples{
## Example of a shiny app that updates a bucket list and rank list
if (interactive()) {
  app <- system.file(
    "shiny/update_rank_list/app.R",
    package = "sortable"
  )
  shiny::runApp(app)
}
}
\seealso{
\link{rank_list}
}
