% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty_fun.R
\name{risk_ua_sa_fun}
\alias{risk_ua_sa_fun}
\title{Internal helper for uncertainty and sensitivity analysis of node risk}
\usage{
risk_ua_sa_fun(
  cyclo_sc,
  indeg_sc,
  btw_sc,
  sample_matrix,
  N,
  params,
  order,
  risk_form = c("additive", "power_mean"),
  eps = 1e-12
)
}
\description{
Computes a vector of node-level risk scores under a Sobol' sampling design and
returns both the uncertainty-analysis draws and Sobol sensitivity indices.
}
\details{
For \code{risk_form = "additive"}, the node risk score is
\deqn{r = \alpha\,\tilde{C} + \beta\,\tilde{d}^{\mathrm{in}} + \gamma\,\tilde{b}\,,}
where \eqn{\tilde{C}}, \eqn{\tilde{d}^{\mathrm{in}}}, and \eqn{\tilde{b}} are scaled
inputs and \eqn{\alpha + \beta + \gamma = 1}.

For \code{risk_form = "power_mean"}, the node risk score is computed as a (weighted) power mean
with exponent \eqn{p}:
\deqn{r =
\left(\alpha\,\tilde{C}^{p} + \beta\,(\tilde{d}^{\mathrm{in}})^{p} + \gamma\,\tilde{b}^{p}\right)^{1/p}\,.}

In the limit \eqn{p \to 0}, this reduces to a weighted geometric mean, implemented
with a small constant \eqn{\epsilon} to avoid \eqn{\log(0)}:
\deqn{r = \exp\left(\alpha\log(\max(\tilde{C},\epsilon)) +
\beta\log(\max(\tilde{d}^{\mathrm{in}},\epsilon)) +
\gamma\log(\max(\tilde{b},\epsilon))\right)\,.}
}
\keyword{internal}
