% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.snreg.R
\name{summary.snreg}
\alias{summary.snreg}
\title{Summary for Skew-Normal Regression Models}
\usage{
\method{summary}{snreg}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"snreg"}, typically returned by \code{\link{snreg}}.}

\item{...}{additional arguments (currently not used).}
}
\value{
An object of class \code{"summary.snreg"}, identical to the input \code{object}
except for its class attribute.
}
\description{
Produces a summary object for objects of class \code{"snreg"}.
The function assigns the class \code{"summary.snreg"} to the fitted model
object, enabling a dedicated print method (\code{print.summary.snreg}) to
display results in a structured format.
}
\details{
Summary Method for snreg Objects


This method expects a fitted \code{"snreg"} object.

\code{summary.snreg} does not modify the contents of the object; it only
updates the class attribute to \code{"summary.snreg"}. The corresponding
print method (\code{\link{print.summary.snreg}}) is responsible for
formatting and displaying estimation details, such as convergence criteria,
log-likelihood, coefficient tables, and (if present) heteroskedastic and
skewness components.
}
\examples{
library(snreg)

data("banks07")
head(banks07)

# Translog cost function specification

spe.tl <- log(TC) ~ (log(Y1) + log(Y2) + log(W1) + log(W2))^2 +
  I(0.5 * log(Y1)^2) + I(0.5 * log(Y2)^2) +
  I(0.5 * log(W1)^2) + I(0.5 * log(W2)^2)

# Specification 1: homoskedastic noise and skewness

formSV <- NULL   # variance equation; constant variance
formSK <- NULL   # skewness equation; constant skewness

m1 <- snreg(
  formula  = spe.tl,
  data     = banks07,
  ln.var.v = formSV,
  skew.v   = formSK
)

summary(m1)

}
\seealso{
\code{\link{snreg}}, \code{\link{print.summary.snreg}}
}
