% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.snreg.R
\name{coef.snreg}
\alias{coef.snreg}
\title{Extract Model Coefficients}
\usage{
\method{coef}{snreg}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"snreg"}, typically returned by \code{\link{snreg}}.}

\item{...}{additional arguments (currently unused).}
}
\value{
A numeric vector containing the model coefficients.
}
\description{
\code{coef.snreg} is the S3 method for extracting the estimated regression
coefficients from an object of class \code{"snreg"}.
}
\details{
Coefficients from an snreg Model


This method simply returns the \code{coef} component stored inside the fitted
\code{"snreg"} object. If the object does not contain coefficient estimates
(e.g., if estimation was not completed in a scaffold), an informative error
is raised.
}
\examples{
library(snreg)

data("banks07")
head(banks07)

# Translog cost function specification

spe.tl <- log(TC) ~ (log(Y1) + log(Y2) + log(W1) + log(W2))^2 +
  I(0.5 * log(Y1)^2) + I(0.5 * log(Y2)^2) +
  I(0.5 * log(W1)^2) + I(0.5 * log(W2)^2)

# Specification 1: homoskedastic noise and skewness

formSV <- NULL   # variance equation; constant variance
formSK <- NULL   # skewness equation; constant skewness

m1 <- snreg(
  formula  = spe.tl,
  data     = banks07,
  ln.var.v = formSV,
  skew.v   = formSK
)

coef(m1)

}
\seealso{
\code{\link{snsf}}, \code{\link{snreg}}, \code{\link{lm.mle}}, \code{\link{vcov.snreg}}, \code{\link{residuals.snreg}}
}
