% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam-ces.R, R/autoces.R
\name{ces}
\alias{ces}
\alias{auto.ces}
\title{Complex Exponential Smoothing}
\usage{
ces(y, seasonality = c("none", "simple", "partial", "full"),
  lags = c(frequency(y)), initial = c("backcasting", "optimal",
  "two-stage", "complete"), a = NULL, b = NULL, loss = c("likelihood",
  "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE", "MSCE", "GPL"), h = 0,
  holdout = FALSE, bounds = c("admissible", "none"), silent = TRUE,
  model = NULL, xreg = NULL, regressors = c("use", "select", "adapt"),
  initialX = NULL, ...)

auto.ces(y, seasonality = c("none", "simple", "partial", "full"),
  lags = c(frequency(y)), initial = c("backcasting", "optimal",
  "two-stage", "complete"), ic = c("AICc", "AIC", "BIC", "BICc"),
  loss = c("likelihood", "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE",
  "MSCE", "GPL"), h = 0, holdout = FALSE, bounds = c("admissible",
  "none"), silent = TRUE, xreg = NULL, regressors = c("use", "select",
  "adapt"), ...)
}
\arguments{
\item{y}{Vector or ts object, containing data needed to be forecasted.}

\item{seasonality}{The type of seasonality used in CES. Can be: \code{none}
- No seasonality; \code{simple} - Simple seasonality, using lagged CES
(based on \code{t-m} observation, where \code{m} is the seasonality lag);
\code{partial} - Partial seasonality with the real seasonal component
(equivalent to additive seasonality); \code{full} - Full seasonality with
complex seasonal component (can do both multiplicative and additive
seasonality, depending on the data). First letter can be used instead of
full words.

In case of the \code{auto.ces()} function, this parameter defines which models
to try.}

\item{lags}{Vector of lags to use in the model. Allows defining multiple seasonal models.}

\item{initial}{Can be either character or a list, or a vector of initial states.
If it is character, then it can be \code{"backcasting"}, meaning that the initials of
dynamic part of the model are produced using backcasting procedure (advised
for data with high frequency), or \code{"optimal"}, meaning that all initial
states are optimised, or \code{"two-stage"}, meaning that optimisation is done
after the backcasting, refining the states. In case of backcasting, the parameters of the
explanatory variables are optimised. Alternatively, you can set \code{initial="complete"}
backcasting, which means that all states (including explanatory variables) are initialised
via backcasting.}

\item{a}{First complex smoothing parameter. Should be a complex number.

NOTE! CES is very sensitive to a and b values so it is advised either to
leave them alone, or to use values from previously estimated model.}

\item{b}{Second complex smoothing parameter. Can be real if
\code{seasonality="partial"}. In case of \code{seasonality="full"} must be
complex number.}

\item{loss}{The type of Loss Function used in optimization. \code{loss} can
be: \code{likelihood} (assuming Normal distribution of error term),
\code{MSE} (Mean Squared Error), \code{MAE} (Mean Absolute Error),
\code{HAM} (Half Absolute Moment), \code{TMSE} - Trace Mean Squared Error,
\code{GTMSE} - Geometric Trace Mean Squared Error, \code{MSEh} - optimisation
using only h-steps ahead error, \code{MSCE} - Mean Squared Cumulative Error.
If \code{loss!="MSE"}, then likelihood and model selection is done based
on equivalent \code{MSE}. Model selection in this cases becomes not optimal.

There are also available analytical approximations for multistep functions:
\code{aMSEh}, \code{aTMSE} and \code{aGTMSE}. These can be useful in cases
of small samples.

Finally, just for fun the absolute and half analogues of multistep estimators
are available: \code{MAEh}, \code{TMAE}, \code{GTMAE}, \code{MACE}, \code{TMAE},
\code{HAMh}, \code{THAM}, \code{GTHAM}, \code{CHAM}.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{bounds}{The type of bounds for the persistence to use in the model
estimation. Can be either \code{admissible} - guaranteeing the stability of the
model, or \code{none} - no restrictions (potentially dangerous).}

\item{silent}{accepts \code{TRUE} and \code{FALSE}. If FALSE, the function
will print its progress and produce a plot at the end.}

\item{model}{A previously estimated GUM model, if provided, the function
will not estimate anything and will use all its parameters.}

\item{xreg}{The vector (either numeric or time series) or the matrix (or
data.frame) of exogenous variables that should be included in the model. If
matrix included than columns should contain variables and rows - observations.
Note that \code{xreg} should have number of observations equal either to
in-sample or to the whole series. If the number of observations in
\code{xreg} is equal to in-sample, then values for the holdout sample are
produced using \link[smooth]{es} function.}

\item{regressors}{The variable defines what to do with the provided xreg:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done.}

\item{initialX}{The vector of initial parameters for exogenous variables.
Ignored if \code{xreg} is NULL.}

\item{...}{Other non-documented parameters. See \link[smooth]{adam} for
details. However, there are several unique parameters passed to the optimiser
in comparison with \code{adam}:
1. \code{algorithm0}, which defines what algorithm to use in nloptr for the initial
optimisation. By default, this is "NLOPT_LN_BOBYQA".
2. \code{algorithm} determines the second optimiser. By default this is
"NLOPT_LN_NELDERMEAD".
3. maxeval0 and maxeval, that determine the number of iterations for the two
optimisers. By default, \code{maxeval0=maxeval=40*k}, where
k is the number of estimated parameters.
4. xtol_rel0 and xtol_rel, which are 1e-8 and 1e-6 respectively.
There are also ftol_rel0, ftol_rel, ftol_abs0 and ftol_abs, which by default
are set to values explained in the \code{nloptr.print.options()} function.}

\item{ic}{The information criterion to use in the model selection.}
}
\value{
Object of class "adam" is returned with similar elements to the
\link[smooth]{adam} function.
}
\description{
Function estimates CES in state space form with information potential equal
to errors and returns several variables.
}
\details{
The function estimates Complex Exponential Smoothing in the state space form
described in Svetunkov et al. (2022) with the information potential
equal to the approximation error.

The \code{auto.ces()} function implements the automatic seasonal component
selection based on information criteria.

\code{ces()} uses two optimisers to get good estimates of parameters. By default
these are BOBYQA and then Nelder-Mead. This can be regulated via \code{...} - see
details below.

For some more information about the model and its implementation, see the
vignette: \code{vignette("ces","smooth")}
}
\examples{
y <- rnorm(100,10,3)
ces(y, h=20, holdout=FALSE)

y <- 500 - c(1:100)*0.5 + rnorm(100,10,3)
ces(y, h=20, holdout=TRUE)

ces(BJsales, h=8, holdout=TRUE)

\donttest{ces(AirPassengers, h=18, holdout=TRUE, seasonality="s")
ces(AirPassengers, h=18, holdout=TRUE, seasonality="p")
ces(AirPassengers, h=18, holdout=TRUE, seasonality="f")}

y <- ts(rnorm(100,10,3),frequency=12)
# CES with and without holdout
auto.ces(y,h=20,holdout=TRUE)
auto.ces(y,h=20,holdout=FALSE)


# Selection between "none" and "full" seasonalities
\donttest{auto.ces(AirPassengers, h=12, holdout=TRUE,
                   seasonality=c("n","f"), ic="AIC")}

ourModel <- auto.ces(AirPassengers)

\donttest{summary(ourModel)}
forecast(ourModel, h=12)

}
\references{
\itemize{
\item Svetunkov I. (2023) Smooth forecasting with the smooth package in R. arXiv:2301.01790.
\doi{10.48550/arXiv.2301.01790}.
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://openforecast.org/category/r-en/smooth/}.
}

\itemize{
\item Svetunkov, I. (2023). Forecasting and Analytics with the Augmented
Dynamic Adaptive Model (ADAM) (1st ed.). Chapman and Hall/CRC.
\doi{10.1201/9781003452652}, online version: \url{https://openforecast.org/adam/}.
}

\itemize{
\item Svetunkov, I., 2023. Smooth Forecasting with the Smooth Package in R. arXiv.
\doi{10.48550/arXiv.2301.01790}
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}

\itemize{
\item  Svetunkov, I., Kourentzes, N., & Ord, J. K. (2022).
Complex exponential smoothing. Naval Research Logistics, 69(8),
1108–1123. https://doi.org/10.1002/nav.22074
}
}
\seealso{
\code{\link[smooth]{adam}, \link[smooth]{es}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
