% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-post_strat_estimator.R
\name{estimate_coverage_overall}
\alias{estimate_coverage_overall}
\alias{estimate_coverage}
\title{Weighted post-stratification estimation of coverage over several service
delivery units}
\usage{
estimate_coverage_overall(cov_df, pop_df, strata, u5, p, k = 3)

estimate_coverage(cov_df, cov_type = c("cf", "tc"), k = 3)
}
\arguments{
\item{cov_df}{A \code{\link[=data.frame]{data.frame()}} of stratified coverage survey data to get
overall coverage estimates of. \code{cov_df} should have a variable named
\code{cases_in} for number of SAM or MAM cases in the programme found during the
survey, \code{cases_out} for number SAM or MAM cases not in the programme found
during the survey, and \code{rec_in} for children recovering from SAM or MAM who
are in the programme found during the survey. A final required variable
should be one that contains identifying geographical information
corresponding to the location from which each row of the survey data was
collected from.}

\item{pop_df}{A \code{\link[=data.frame]{data.frame()}} with at least two variables: \code{strata} for the
stratification/grouping information that matches the grouping information
in \code{cov_df} and \code{pop} for information on population for the given grouping
information.}

\item{strata}{A character value of the variable name in \code{cov_df} that
corresponds to the \code{strata} values to match with values in \code{pop_df}.}

\item{u5}{A numeric value for the proportion of the population that is under
years old.}

\item{p}{Prevalence of SAM or MAM in the given population.}

\item{k}{Correction factor. Ratio of the mean length of an untreated episode
to the mean length of a CMAM treatment episode}

\item{cov_type}{Coverage estimator to report. Either \emph{"cf"} for
\emph{case-finding effectiveness} or \emph{"tc"} for \emph{treatment coverage}.
Default is \emph{"cf"}.}
}
\value{
A list of overall coverage estimates with corresponding 95\%
confidence intervals for case-finding effectiveness and treatment coverage.
}
\description{
Weighted post-stratification estimation of coverage over several service
delivery units
}
\examples{
cov_df <- survey_data

pop_df <- pop_data |>
  setNames(nm = c("strata", "pop"))

estimate_coverage_overall(
  cov_df, pop_df, strata = "district", u5 = 0.177, p = 0.01
)

}
