% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regress}
\alias{regress}
\alias{regress.slcafit}
\title{Regress Exogenous Variables on Latent Variables}
\usage{
regress(object, ...)

\method{regress}{slcafit}(
   object, formula, data = parent.frame(),
   imputation = c("modal", "prop"),
   method = c("naive", "BCH", "ML"), ...
)

\method{regress}{slcafit}(
  object,
  formula,
  data = parent.frame(),
  imputation = c("modal", "prop"),
  method = c("naive", "BCH", "ML"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{slcafit}.}

\item{...}{additional arguments.}

\item{formula}{a formula specifying the regression model, including both latent class variables (from the estimated model) and exogenous variables.}

\item{data}{an optional \code{data.frame} containing the exogenous variables of interest. If omitted, the variables are taken from the parent environment.}

\item{imputation}{a character string specifying the imputation method for latent class assignment. Options include:
\itemize{
\item \code{"modal"}: Assigns each individual to the latent class with the highest posterior probability.
\item \code{"prop"}: Assigns classes probabilistically based on the posterior probability distribution.
}}

\item{method}{a character string specifying the method to adjust for bias in the three-step approach. Options include:
\itemize{
\item \code{"naive"}: A simple approach without correction for classification error.
\item \code{"BCH"}: The bias-adjusted Bolck, Croon, and Hagenaars method.
\item \code{"ML"}: A maximum likelihood approach that accounts for classification error.
}}
}
\value{
A \code{list} of class \code{reg.slca} with the following components:
\item{coefficients}{A matrix of regression coefficients representing the odds ratios for each latent class against the baseline class (the last class).}
\item{std.err}{A matrix of standard errors corresponding to the regression coefficients.}
\item{vcov}{The variance-covariance matrix of the regression coefficients.}
\item{dim}{The dimensions of the coefficients matrix.}
\item{ll}{The log-likelihood of the regression model.}

The \code{summary} function can be used to display the regression coefficients, standard errors, Wald statistics, and p-values. The standard errors are derived by numerically calculated Hessian matrix from \code{nlm} function.
}
\description{
Performs regression analysis to examine the influence of exogenous (external) variables on latent class variables in an estimated \code{slca} model. The function uses logistic regression with a three-step approach to account for measurement error.
}
\examples{
library(magrittr)
names(nlsy97)
nlsy_jlcpa \%>\% regress(SMK_98 ~ SEX, nlsy97)
\donttest{
nlsy_jlcpa \%>\% regress(PROF ~ SEX, nlsy97)
}
}
\references{
Vermunt, J. K. (2010). Latent Class Modeling with Covariates: Two Improved Three-Step Approaches. Political Analysis, 18(4), 450–469. http://www.jstor.org/stable/25792024
}
