% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{purrr_bar}
\alias{purrr_bar}
\title{Execute a purrr or furrr function with a progress
bar.}
\usage{
purrr_bar(
  ...,
  .purrr,
  .f,
  .f_args = list(),
  .purrr_args = list(),
  .steps,
  .slow = FALSE,
  .progress = TRUE
)
}
\arguments{
\item{...}{iterable arguments passed to .purrr}

\item{.purrr}{purrr or furrr function}

\item{.f}{function to be executed over iterables}

\item{.f_args}{list of arguments passed to .f, Default: list()}

\item{.purrr_args}{list of arguments passed to .purrr, Default: list()}

\item{.steps}{integer number of iterations}

\item{.slow}{logical slows down execution, Default: FALSE}

\item{.progress}{logical, show progress bar, Default: TRUE}
}
\value{
result of function passed to .f
}
\description{
Internal utility function.
}
\details{
Call still needs to be wrapped in \code{\link[progressr]{with_progress}}
or \code{\link[=with_progress_cnd]{with_progress_cnd()}}
}
\examples{
# purrr::map
progressr::with_progress(
  purrr_bar(rep(0.25, 5), .purrr = purrr::map, .f = Sys.sleep, .steps = 5)
)

\donttest{
# purrr::walk
progressr::with_progress(
 purrr_bar(rep(0.25, 5), .purrr = purrr::walk,.f = Sys.sleep, .steps = 5)
)

# progress bar off
progressr::with_progress(
  purrr_bar(
    rep(0.25, 5), .purrr = purrr::walk,.f = Sys.sleep, .steps = 5, .progress = FALSE
  )
)

# purrr::map2
progressr::with_progress(
  purrr_bar(
    rep(1, 5), rep(2, 5),
    .purrr = purrr::map2,
    .f = `+`,
    .steps = 5,
    .slow = TRUE
 )
)

# purrr::pmap
progressr::with_progress(
  purrr_bar(
    list(rep(1, 5), rep(2, 5)),
    .purrr = purrr::pmap,
    .f = `+`,
    .steps = 5,
    .slow = TRUE
 )
)

# define function within purr_bar() call
progressr::with_progress(
  purrr_bar(
    list(rep(1, 5), rep(2, 5)),
    .purrr = purrr::pmap,
    .f = function(x, y) {
      paste0(x, y)
    },
    .steps = 5,
    .slow = TRUE
 )
)

# with mutate
progressr::with_progress(
 tibble::tibble(x = rep(0.25, 5)) \%>\%
  dplyr::mutate(x = purrr_bar(x, .purrr = purrr::map, .f = Sys.sleep, .steps = 5))
)
}
}
