% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-biomass.R
\name{eq_biomass_menendez_2022}
\alias{eq_biomass_menendez_2022}
\title{Biomass equations for young Spanish plantations}
\usage{
eq_biomass_menendez_2022(species, return_r2 = FALSE, return_rmse = FALSE)
}
\arguments{
\item{species}{A character string specifying the scientific name of the tree
species. It can be a column name if all the species are included in this model.
See Details for available species.}

\item{return_r2}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}

\item{return_rmse}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}
}
\value{
A S7 list of parameters
}
\description{
Allometric equations for young (<30) plantations of 18 Spanish species including
broadleaf and conifer species. Only aboveground biomass.
}
\details{
There are 15 species in this model, including generic equations for \emph{Conifers},
\emph{Deciduous broadleaves}, and \emph{Evergreen broadleaves}.

All the models measure only aboveground biomass.
}
\examples{
## get model parameters for silv_predict_biomass
eq_biomass_menendez_2022("Fagus sylvatica")
}
\seealso{
\code{\link[=silv_predict_biomass]{silv_predict_biomass()}}, \link{biomass_models}, \code{\link[=eq_biomass_montero_2005]{eq_biomass_montero_2005()}}, \code{\link[=eq_biomass_dieguez_aranda_2009]{eq_biomass_dieguez_aranda_2009()}}
\code{\link[=eq_biomass_ruiz_peinado_2011]{eq_biomass_ruiz_peinado_2011()}}, \code{\link[=eq_biomass_ruiz_peinado_2012]{eq_biomass_ruiz_peinado_2012()}}, \code{\link[=eq_biomass_manrique_2017]{eq_biomass_manrique_2017()}},
\code{\link[=eq_biomass_cudjoe_2024]{eq_biomass_cudjoe_2024()}}
}
