% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_bands.R
\name{store_bands}
\alias{store_bands}
\title{Store Raster Bands to PostGIS}
\usage{
store_bands(
  raster,
  conn,
  schema = "public",
  prefix = NULL,
  postfix = NULL,
  bands = NULL
)
}
\arguments{
\item{raster}{A character string specifying the file path to the GeoTIFF file
containing the raster bands to be stored.}

\item{conn}{A database connection object to a PostGIS database (e.g., from `RPostgres::dbConnect`).}

\item{schema}{A string specifying the schema in the PostGIS database where
the raster layers will be stored. Default is `"public"`.}

\item{prefix}{A string to prepend to each layer name. Default is `NULL`.}

\item{postfix}{A string to append to each layer name. Default is `NULL`.}

\item{bands}{A named integer vector, index of the bands to store with layer names.
If it is `NULL`, which is the default value, all bands are stored using the band
name as the layer name. If unnamed indices are provided, the band name is also used
as the layer name.}
}
\value{
Invisibly returns a character vector of the names of the tables written to PostGIS.
}
\description{
Stores each band of a raster to a specified schema in a PostGIS database. Each
band is written as a separate table in the database.
}
\details{
Transforms the table name according to the Snake Case convention.
}
\examples{
\dontrun{
conn <- DBI::dbConnect(
  RPostgres::Postgres(),
  dbname = "mydb",
  host = "localhost",
  user = "user",
  password = "password"
)

sr <- terra::rast(nrows = 10, ncols = 10, nlyrs = 3, vals = runif(300))
sr_file <- tempfile(fileext = ".tif")
terra::writeRaster(sr, sr_file, filetype = "GTiff", overwrite = TRUE)

tables <- store_bands(sr_file, conn, schema = "geodata", prefix = "example_", postfix = "_raster")

DBI::dbDisconnect(conn)
}

}
\seealso{
Other write to PostGIS: 
\code{\link{store_layers}()},
\code{\link{store_raster}()}
}
\concept{write to PostGIS}
