% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_publish_layer.R
\name{publish_layer}
\alias{publish_layer}
\alias{publish_layer.geoserver}
\title{Publish a Vector Layer to GeoServer}
\usage{
publish_layer(gso, layer, title)

\method{publish_layer}{geoserver}(gso, layer, title = NULL)
}
\arguments{
\item{gso}{An object of class `geoserver` containing GeoServer connection details.}

\item{layer}{A string, the name of the layer to publish.}

\item{title}{A string, an optional title for the layer. Defaults to the layer
name if not provided.}
}
\value{
An integer:
\itemize{
  \item \code{0} if the operation was successful or if the layer already exists.
  \item \code{1} if an error occurred.
}
}
\description{
Publishes a vector layer to GeoServer. The layer source must have previously
been defined as a GeoSever datastore.
}
\details{
Prints an appropriate message indicating success or failure.
}
\examples{
\dontrun{
gso <- geoserver(
  url = "http://localhost:8080/geoserver",
  user = "admin",
  password = "geoserver",
  workspace = "sigugr_test"
)

gso <- gso |>
  register_datastore_postgis(
    "sigugr-postgis",
    db_name = 'sigugr_example',
    host = 'localhost',
    port = 5432,
    db_user = 'user',
    db_password = 'password',
    schema = "public"
  )

gso |>
  publish_layer(layer = 'sigugr_layer')
}
}
\seealso{
Other publish to GeoServer: 
\code{\link{geoserver}()},
\code{\link{publish_bands}()},
\code{\link{publish_layer_set}()},
\code{\link{publish_raster}()},
\code{\link{register_datastore_postgis}()}
}
\concept{publish to GeoServer}
