% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs.R
\name{geoserver}
\alias{geoserver}
\title{GeoServer Connection Object (`geoserver` S3 Class)}
\usage{
geoserver(url, user, password, workspace)
}
\arguments{
\item{url}{A character string specifying the base URL of the GeoServer instance
(e.g., `"http://localhost:8080/geoserver"`).}

\item{user}{A character string representing the GeoServer username with the
required permissions.}

\item{password}{A character string representing the password for the specified user.}

\item{workspace}{A character string specifying the default workspace to use in
GeoServer operations.}
}
\value{
An object of class `geoserver` or NULL if an error occurred.
}
\description{
This S3 class represents a connection to a GeoServer instance.
It stores the connection details, including the base URL, user credentials,
and the default workspace.
}
\examples{
\dontrun{
gso <- geoserver(
  url = "http://localhost:8080/geoserver",
  user = "admin",
  password = "geoserver",
  workspace = "sigugr_test"
)
}

}
\seealso{
Other publish to GeoServer: 
\code{\link{publish_bands}()},
\code{\link{publish_layer}()},
\code{\link{publish_layer_set}()},
\code{\link{publish_raster}()},
\code{\link{register_datastore_postgis}()}
}
\concept{publish to GeoServer}
