% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_raster.R
\name{clip_raster}
\alias{clip_raster}
\title{Clip a raster based on a polygon}
\usage{
clip_raster(raster, polygon, keep_crs = TRUE)
}
\arguments{
\item{raster}{A `terra` raster to be clipped.}

\item{polygon}{A `sf` polygon layer used for clipping.}

\item{keep_crs}{Logical. If `TRUE`, retains the original CRS of the raster.
If `FALSE`, transforms the raster to the polygon CRS. Default is `TRUE`.}
}
\value{
A `terra` raster clipped to the extent of the polygon.
}
\description{
Clips a raster using a polygon, preserving the coordinate reference system (CRS)
of the raster.
}
\examples{
source_gpkg <- system.file("extdata", "sigugr.gpkg", package = "sigugr")
p <-sf::st_read(source_gpkg, layer = 'lanjaron', quiet = TRUE)

source_tif <- system.file("extdata", "sat.tif", package = "sigugr")
r <- terra::rast(source_tif)

result <- clip_raster(r, p)

}
\seealso{
Other clip functions: 
\code{\link{clip_layer}()},
\code{\link{clip_multipoligon}()},
\code{\link{generate_bbox}()}
}
\concept{clip functions}
