% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sicure.R
\name{loglik.simcm}
\alias{loglik.simcm}
\title{Logarithm of the likelihood of a single-index mixture cure model}
\usage{
loglik.simcm(x, time, delta, logh1, logh2, logh3, logh4, r, k = 10)
}
\arguments{
\item{x}{A numeric vector giving the covariate values.}

\item{time}{A numeric vector giving the observed times.}

\item{delta}{A numeric vector giving the values of the uncensoring indicator, where 1 indicates that the event of interest has been observed and 0 indicates that the observation is censored.}

\item{logh1}{The logarithm of the bandwidth used to smooth the covariate in the nonparametric estimation of the probability of cure.}

\item{logh2}{The logarithm of the bandwidth used to smooth the covariate in the nonparametric estimation of the latency.}

\item{logh3}{The logarithm of the bandwidth used to smooth the time variable in the nonparametric estimation of the conditional density of susceptible individuals.}

\item{logh4}{The logarithm of the bandwidth used to smooth the covariate in the nonparametric estimation of the conditional density of susceptible individuals.}

\item{r}{The radius of the moving window used to smooth the nonparametric estimation of the probability of cure.}

\item{k}{The number of nearest neighbors used to smooth the nonparametric estimation of the conditional density of susceptible individuals.}
}
\value{
A list with two components:
\itemize{
\item The value of the negative log-likelihood.
\item The \eqn{n} terms that contribute to the negative log-likelihood.
}
}
\description{
This function computes the logarithm of the likelihood of a single-index mixture cure model.
}
