% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/human.R
\name{human-shiny}
\alias{human-shiny}
\alias{humanOutput}
\alias{renderHuman}
\title{Shiny bindings for human}
\usage{
humanOutput(outputId, width = "100\%", height = "400px")

renderHuman(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a human}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
A \code{shiny.tag.list} object (in the case of \code{humanOutput}) or a
\code{shiny.render.function} object (in the case of \code{renderHuman}).
}
\description{
Output and render functions for using human within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
  library(shiny)

  male_organs <- shinybody::shinybody_organs$organ[shinybody::shinybody_organs$male]
  female_organs <- shinybody::shinybody_organs$organ[shinybody::shinybody_organs$female]

  ui <- function() {
    fluidPage(
      selectInput(
        inputId = "gender",
        label = "Select Gender",
        choices = c("male", "female"),
        multiple = FALSE,
        selected = "male"
      ),
      selectInput(
        inputId = "body_parts",
        label = "Select Body Parts to Show",
        choices = male_organs,
        multiple = TRUE,
        selected = male_organs[1:5]
      ),
      humanOutput(outputId = "human_widget"),
      verbatimTextOutput(outputId = "clicked_body_part_msg"),
      verbatimTextOutput(outputId = "selected_body_parts_msg")
    )
  }

  server <- function(input, output, session) {
    observe({
      g <- input$gender
      if (g == "male") {
        organ_choices <- male_organs
      } else {
        organ_choices <- female_organs
      }

      updateSelectInput(
        session = session,
        inputId = "body_parts",
        choices = organ_choices,
        selected = organ_choices[1:5]
      )
    })

    output$human_widget <- renderHuman({
      selected_organ_df <- subset(
        shinybody::shinybody_organs,
        organ \%in\% input$body_parts
      )
      selected_organ_df$show <- TRUE
      human(
        organ_df = selected_organ_df,
        select_color = "red"
      )
    })
    output$clicked_body_part_msg <- renderPrint({
      paste("You Clicked:", input$clicked_body_part)
    })
    output$selected_body_parts_msg <- renderPrint({
      paste("Selected:", paste(input$selected_body_parts, collapse = ", "))
    })
  }

  shinyApp(ui = ui, server = server)
}
}
