% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-search.R
\name{searchInput}
\alias{searchInput}
\title{Search Input}
\usage{
searchInput(
  inputId,
  label = NULL,
  value = "",
  placeholder = NULL,
  btnSearch = NULL,
  btnReset = NULL,
  btnClass = "btn-default btn-outline-secondary",
  resetValue = "",
  inputType = "text",
  width = NULL
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value.}

\item{placeholder}{A character string giving the user a hint as to what can be entered into the control.}

\item{btnSearch}{An icon for the button which validate the search.}

\item{btnReset}{An icon for the button which reset the search.}

\item{btnClass}{Class to add to buttons, if a vector of length 2 the first value is used for search button and second one for reset button.}

\item{resetValue}{Value used when reset button is clicked, default to \code{""} (empty string),
if \code{NULL} value is not reset.}

\item{inputType}{The type of input to use, default is \code{"text"} but you can also use \code{"password"} for example,
see \href{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/text}{developer.mozilla.org} for other possible types.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}
}
\description{
A text input only triggered when Enter key is pressed or search button clicked
}
\note{
The two buttons ('search' and 'reset') act like \code{\link[shiny:actionButton]{shiny::actionButton()}}, you can
retrieve their value server-side with \verb{input$<INPUTID>_search} and \verb{input$<INPUTID>_reset}.
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  # theme = bslib::bs_theme(version = 5L, preset = "bootstrap"),
  tags$h1("Search Input"),
  br(),
  searchInput(
    inputId = "search", label = "Enter your text",
    placeholder = "A placeholder",
    btnSearch = icon("magnifying-glass"),
    btnReset = icon("xmark"),
    width = "450px"
  ),
  br(),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {
  output$res <- renderPrint(input$search)
}

if (interactive())
  shinyApp(ui = ui, server = server)
}
\seealso{
\code{\link[=updateSearchInput]{updateSearchInput()}} to update value server-side.
}
