% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_synteny.R
\name{get_segments}
\alias{get_segments}
\title{Get Segmented Data from Anchorpoints and Ks Values}
\usage{
get_segments(
  genes_file,
  anchors_ks_file,
  multiplicons_file,
  segmented_file,
  segmented_anchorpoints_file,
  num_anchors = 10
)
}
\arguments{
\item{genes_file}{A character string specifying the file path for genes information created by i-ADHoRe.}

\item{anchors_ks_file}{A character string specifying the file path for anchorpoints Ks values data.}

\item{multiplicons_file}{A character string specifying the file path for multiplicons information created by i-ADHoRe.}

\item{segmented_file}{A character string specifying the output file path for segmented data.}

\item{segmented_anchorpoints_file}{A character string specifying the output file path for segmented anchorpoints.}

\item{num_anchors}{An integer specifying the minimum number of anchorpoints required.}
}
\value{
NULL (output files are generated with the specified information).
}
\description{
This function extracts segmented data from anchorpoints and Ks (synonymous substitution rate) values,
based on specified criteria, and writes the results to output files.
}
