% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks_resample_95_CI.R
\name{bootStrapPeaks}
\alias{bootStrapPeaks}
\title{Bootstrap Peaks in the Ks Distribution}
\usage{
bootStrapPeaks(
  ksRaw,
  binWidth = 0.1,
  maxK = 5,
  m = 3,
  peak.index = 1,
  peak.maxK = 2,
  spar = 0.25,
  rep = 1000,
  from = 0,
  to = maxK
)
}
\arguments{
\item{ksRaw}{A numeric vector representing the raw Ks distribution to be bootstrapped.}

\item{binWidth}{A numeric value indicating the bin width for histogram calculation.}

\item{maxK}{A numeric value indicating the maximum Ks value to consider in the distribution.}

\item{m}{An integer specifying the parameter for peak detection.}

\item{peak.index}{An integer indicating the index of the peak to be estimated.}

\item{peak.maxK}{A numeric value indicating the maximum Ks value for peak estimation.}

\item{spar}{A numeric value controlling the smoothness of spline fitting.}

\item{rep}{An integer specifying the number of bootstrap repetitions.}

\item{from}{A numeric value indicating the lower bound for peak estimation.}

\item{to}{A numeric value indicating the upper bound for peak estimation.}
}
\value{
A numeric vector containing bootstrapped peak estimates.
}
\description{
This function performs bootstrapping on a given Ks (synonymous substitution rates) distribution
to estimate peaks within the distribution.
}
