% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_visSbm.R
\name{visSbm}
\alias{visSbm}
\title{visSbm}
\usage{
visSbm(
  x,
  labels = "default",
  node_names = NULL,
  directed = "default",
  settings = list()
)
}
\arguments{
\item{x}{Sbm model of class `BipartiteSBM_fit`, `SimpleSBM_fit` or simple numeric `matrix`.}

\item{labels}{labels for nodes. If it's simple sbm it should be a single character ("default" -> c("nodes")).
If sbm is bipartite a named character (names are row and col) ("default" -> c(row = 'row', col = 'col')).}

\item{node_names}{if NULL do nothing specific, but list of nodes are given
the graph get interactive and nodes names are showed by clicking on a block.
In bipartite case a named list:
\describe{
 \item{"row": }{character: node names in rows}
 \item{"col": }{character: node names in columns}
 }
 In unipartite case a single character vector containing the nodes names (Default = NULL).}

\item{directed}{Boolean indicating whether or not the network is directed by default, a asymmetrical matrix will be seen as directed.}

\item{settings}{list of settings}
}
\value{
a visNetwork visual of the x object
}
\description{
A fct that plot a \pkg{visNetwork} plot of a adjacency matrix or an Sbm fit from the \pkg{sbm} package.
}
\details{
List of parameters
\describe{
 \item{"edge_threshold": }{"default" erases as many small edges as it can without isolating any nodes (no connection).
 It can also be a numeric value between 0 and 1, relative (between min and max) filter for small edges value}
 \item{"edge_color": }{character: color of edges (default: "lightblue")}
 \item{"arrows": }{boolean: should edges be arrows}
 \item{"arrow_thickness": }{numeric: arrows size}
 \item{"arrow_start": }{character: "row" or "col" or labels value according to row or columns. The arrow will start from selected to the the other value}
 \item{"node_color": }{named character: Bipartite case c(row = "row_color", col = "col_color"). Unipartite case c("node_color")}
 \item{"node_shape": }{named character: Bipartite case c(row = "row_shape", col = "col_shape"). Unipartite case c("node_shape"). Value from visNetwork shape argument of visEdges function ("triangle","dot","square",etc...)}
 \item{"digits": }{integer: number of digits to show when numbers are shown (default: 2)}
}
}
\examples{

# my_sbm_bi <- sbm::estimateBipartiteSBM(sbm::fungusTreeNetwork$fungus_tree,
#                                        model = 'bernoulli')
my_sbm_bi <- FungusTreeNetwork$sbmResults$fungus_tree

node_names_bi <- list(
  row = FungusTreeNetwork$networks$fungus_names,
  col = FungusTreeNetwork$networks$tree_names
)

visSbm(my_sbm_bi,
  labels = c(row = "Fungus", col = "Tree"),
  node_names = node_names_bi,
  settings = list(
    arrows = TRUE,
    arrow_start = "Fungus",
    node_color = c(row = "pink", col = "green"),
    node_shape = c(row = "dot", col = "square")
  )
)


# my_sbm_uni <- sbm::estimateSimpleSBM(sbm::fungusTreeNetwork$tree_tree,
#                                      model = "poisson")
my_sbm_uni <- FungusTreeNetwork$sbmResults$tree_tree

node_names_uni <- list(FungusTreeNetwork$networks$tree_names)

visSbm(my_sbm_uni,
  labels = c("Tree"),
  node_names = node_names_uni,
  settings = list(
    edge_threshold = 0.01,
    edge_color = "grey",
    node_color = c("violet")
  )
)

}
