% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack_randomized.R
\name{unpack_randomized}
\alias{unpack_randomized}
\title{unpack_randomized}
\usage{
unpack_randomized(raster)
}
\arguments{
\item{raster}{rd_ras object with randomized raster.}
}
\value{
rd_ras
}
\description{
Load randomized raster object
}
\details{
Because of how SpatRaster are saved (need to be packed), this function allows to
unpack previously packed raster objects that were saved using \code{pack_randomized}.
For further details, see \code{wrap}.
}
\examples{
\dontrun{
landscape_classified <- classify_habitats(terra::rast(landscape), n = 5, style = "fisher")
landscape_random <- randomize_raster(landscape_classified, n_random = 3)
x <- pack_randomized(raster = landscape_random)
y <- unpack_randomized(raster = y)
}

}
\seealso{
\code{\link{pack_randomized}}
\code{\link[terra]{wrap}}
}
