% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolocate.R
\name{geolocate}
\alias{geolocate}
\title{Geolocate historical toponyms}
\usage{
geolocate(df, place = "place", iso = "iso")
}
\arguments{
\item{df}{A data frame with two columns, places names and two-letter ISO codes for regions}

\item{place}{A column with toponyms in the data frame}

\item{iso}{A column of ISO codes for regions}
}
\value{
A data frame of the geospatial data
}
\description{
This function uses the API for the World Historical Gazeteer to geolocate place names.
It takes the place name and region as inputs and returns a data frame with results,
primarily the longitude and latitude.
}
\examples{
# Search for Paris and Edo (now Tokyo)
example.df <- data.frame("place" = c("Paris","Edo"), "iso" = c("FR","JP"))
geolocate(example.df)
}
\keyword{map}
\keyword{sf}
\keyword{spatial}
