% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir_basic_model.R
\name{sir_basic_model}
\alias{sir_basic_model}
\title{Basic SIR model}
\usage{
sir_basic_model(times, state, parameters)
}
\arguments{
\item{times}{time sequence.}

\item{state}{the initial state of the model.}

\item{parameters}{the parameters of the model.}
}
\value{
list of class sir_basic_model with the following items
  \item{parameters}{list of parameters used for fitting the model}
  \item{output}{matrix of population for each compartment over time}
}
\description{
Refers to section 3.1.3.
}
\details{
In \code{state}:

 - \code{S}: number of susceptible

 - \code{I}: number of infected

 - \code{R}: number of recovered

In \code{parameters}:

 - \code{alpha}: disease-related death rate

 - \code{mu}: natural death rate (= 1/life expectancy)

 - \code{beta}: transmission rate

 - \code{nu}: recovery rate

 - \code{p}: percent of population vaccinated at birth
}
\examples{
state <- c(S=4999, I=1, R=0)
parameters <- c(
  mu=1/75, # 1 divided by life expectancy (75 years old)
  alpha=0, # no disease-related death
  beta=0.0005, # transmission rate
  nu=1, # 1 year for infected to recover
  p=0 # no vaccination at birth
)
times <- seq(0, 250, by=0.1)
model <- sir_basic_model(times, state, parameters)
model

}
