% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesizers.R
\name{getSynth}
\alias{getSynth}
\title{Synthesizer}
\usage{
getSynth(
  notes,
  nHarmonics = 5,
  peak = 0.03,
  decay = 0.8,
  duration = 1,
  sustain = 0.25,
  decayPar = 1,
  sustainPar = 4,
  type = "sine"
)
}
\arguments{
\item{notes}{Character vector, note names}

\item{nHarmonics}{Integer >=1, number of harmonics}

\item{peak}{Numeric, peak time in seconds}

\item{decay}{Numeric, end-of-decay time in seconds}

\item{duration}{Numeric, total duration in seconds}

\item{sustain}{Numeric, sustain volume}

\item{decayPar}{Numeric, the higher the value the smaller the decay time for higher harmonics}

\item{sustainPar}{Numeric, the higher the value the smaller the sustain volume for higher harmonics}

\item{type}{String, oscillator type, one of 'sine', 'saw', 'square' or 'triangle'.
If an unknown string is provided, a sine oscillator will be used.}
}
\value{
An object of class 'instrument'.
}
\description{
Creates an additive, Hammond-inspired Synthesizer.
Higher harmonics decay faster and have smaller sustain.
}
\examples{
synth <- getSynth(c('E2','B2','E3','G3','A3'))
w=play.instrument(synth,time=(0:(length(synth)-1))*0.5,fadeout=rep(Inf,length(synth)))
tuneR::plot(w)
\dontrun{
# This line of code is wrapped in \dontrun{} since it relies
# on an external audio player to play the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
tuneR::play(w)}
}
