% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_retention.R
\name{st_retention}
\alias{st_retention}
\title{Fetch Retention Data for Apps}
\usage{
st_retention(
  unified_app_id = NULL,
  ios_app_id = NULL,
  android_app_id = NULL,
  os = NULL,
  country = "US",
  date_granularity = "all_time",
  start_date = NULL,
  end_date = NULL,
  auth_token = NULL,
  verbose = TRUE
)
}
\arguments{
\item{unified_app_id}{Character string. Sensor Tower unified app ID (24-character hex).
Will be resolved to platform-specific IDs automatically.}

\item{ios_app_id}{Character string. iOS app ID (numeric, e.g., "1234567890").}

\item{android_app_id}{Character string. Android package name (e.g., "com.example.app").}

\item{os}{Character string. Operating system: "ios" or "android". Required if using
platform-specific IDs. When using unified_app_id, defaults to "ios" but will
try both platforms.}

\item{country}{Character string. Country code (e.g., "US", "GB"). Default is "US".
Only single country supported per request.}

\item{date_granularity}{Character string. Either "all_time" (default) or "quarterly".
All-time data goes back to Q4 2015. Quarterly data begins Q1 2021.}

\item{start_date}{Date or character string. Start date for quarterly data in "YYYY-MM-DD" format.
Ignored for all_time granularity.}

\item{end_date}{Date or character string. End date for quarterly data in "YYYY-MM-DD" format.
Ignored for all_time granularity.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
A [tibble][tibble::tibble] with retention metrics including:
  - **app_id**: The platform-specific app ID
  - **os**: Platform (ios or android)
  - **country**: Country code
  - **retention_d1** through **retention_d90**: Retention percentages (0-1 scale)
  - **confidence**: Data confidence level (red=low, yellow=medium, green=high)
  - **baseline_downloads**: Total downloads in baseline period
  - **baseline_start_date**, **baseline_end_date**: Dates for baseline period
}
\description{
Retrieves retention metrics (D1-D90) for specific apps from the Sensor Tower
Usage Intelligence API. This function queries the retention endpoint directly
using platform-specific app IDs.
}
\section{Data Availability}{

- Quarterly data begins Q1 2021
- All-time data goes back to Q4 2015
- Data is only available for apps with sufficient user base
- Confidence levels: red (<=3), yellow (4-6), green (>=7)
}

\section{Recommended Workflow}{

```
# Step 1: Search for app by name
app <- st_app_info("Royal Match")

# Step 2: Get retention data using unified ID
retention <- st_retention(unified_app_id = app$unified_app_id[1])
```
}

\examples{
\dontrun{
# Get retention for an app using unified ID
retention <- st_retention(unified_app_id = "5f16a8019f7b275235017614")

# Get retention for iOS app directly
retention <- st_retention(
  ios_app_id = "553834731",
  os = "ios",
  country = "US"
)

# Get quarterly retention data
retention <- st_retention(
  unified_app_id = "5f16a8019f7b275235017614",
  date_granularity = "quarterly",
  start_date = "2024-01-01",
  end_date = "2024-09-30"
)
}

}
\seealso{
[st_app_info()] for searching apps by name,
  [st_app_lookup()] for resolving app IDs,
  [st_demographics()] for user demographics data
}
