% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_url_parser.R
\name{st_parse_web_url}
\alias{st_parse_web_url}
\title{Parse Sensor Tower Web URL to API Parameters}
\usage{
st_parse_web_url(url, verbose = TRUE)
}
\arguments{
\item{url}{Character string. A Sensor Tower web interface URL}

\item{verbose}{Logical. Whether to print parameter mapping details. 
Defaults to TRUE.}
}
\value{
List of API-compatible parameters suitable for use with st_top_charts()
  and other sensortowerR functions
}
\description{
Converts a Sensor Tower web interface URL into API-compatible parameters
that can be used with sensortowerR functions. This is helpful when you want
to replicate a web query in R.
}
\examples{
\dontrun{
# Parse a web URL
url <- "https://app.sensortower.com/market-analysis/top-apps?os=unified&measure=DAU"
params <- st_parse_web_url(url)

# Use the parameters in an API call
data <- do.call(st_top_charts, params)

# Or modify parameters before using
params$limit <- 50
data <- do.call(st_top_charts, params)
}
}
