% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_category_rankings.R
\name{st_category_rankings}
\alias{st_category_rankings}
\title{Fetch App Store Category Rankings}
\usage{
st_category_rankings(
  os,
  category = NULL,
  chart_type = NULL,
  country = "US",
  date = NULL,
  limit = 100,
  offset = 0,
  custom_fields_filter_id = NULL,
  custom_tags_mode = NULL,
  auth_token = NULL
)
}
\arguments{
\item{os}{Character string. Required. Operating system: "ios", "android", or "unified".}

\item{category}{Character or numeric. Category ID to fetch rankings for.
Use `st_categories()` to find valid category IDs. Required unless 
`custom_fields_filter_id` is provided.}

\item{chart_type}{Character string. The chart type to retrieve. Options vary by OS:
- iOS: "topfreeapplications", "toppaidapplications", "topgrossingapplications", etc.
- Android: "topselling_free", "topselling_paid", "topgrossing", etc.
Defaults to "topfreeapplications" for iOS, "topselling_free" for Android.}

\item{country}{Character string. Two-letter country code (e.g., "US", "GB").
Defaults to "US".}

\item{date}{Date or character string in "YYYY-MM-DD" format. Date for rankings.
Defaults to NULL (uses today's date).}

\item{limit}{Numeric. Number of results to return (1-400). Defaults to 100.}

\item{offset}{Numeric. Offset for pagination. Defaults to 0.}

\item{custom_fields_filter_id}{Optional. Character string. ID of a Sensor
Tower custom field filter to apply. Use filter IDs from the web interface
at app.sensortower.com. When provided, this filter will be applied to the
results. The 'category' parameter becomes optional when using a custom filter.}

\item{custom_tags_mode}{Optional. Character string. Required if `os` is
'unified' and `custom_fields_filter_id` is provided. Specifies how the
custom filter applies to unified apps. Options: "include", "exclude",
"include_unified_apps". The "include_unified_apps" option includes all
platform versions when any version matches the filter.}

\item{auth_token}{Character string. Sensor Tower API authentication token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}
}
\value{
A [tibble][tibble::tibble] containing ranking data with columns:
  - `rank`: The app's position in the chart
  - `app_id`: The app's store ID
  - `category`: The category ID
  - `country`: The country code
  - `date`: The ranking date
  - `chart_type`: The chart type
  - `os`: The operating system
}
\description{
Retrieves the top ranking apps for a specific category and chart type from
the App Store or Google Play Store. This provides the official store rankings
as they appear in the actual app stores.
}
\note{
The API returns only app IDs, not names. To get app names and other
  metadata, use the app IDs with `st_app_details()`.
}
\section{API Endpoint Used}{

  - `GET /v1/\{os\}/ranking`
}

\examples{
\dontrun{
# Get top free games in the US
top_games <- st_category_rankings(
  os = "ios",
  category = 6014,  # Games category
  chart_type = "topfreeapplications",
  country = "US",
  limit = 50
)

# Get top grossing apps in UK for a specific date
top_grossing <- st_category_rankings(
  os = "android",
  category = "game",
  chart_type = "topgrossing",
  country = "GB",
  date = "2024-01-15",
  limit = 100
)

# Use custom filter instead of category
filtered_rankings <- st_category_rankings(
  os = "ios",
  custom_fields_filter_id = "60746340241bc16eb8a65d76",
  chart_type = "topgrossingapplications",
  country = "US",
  limit = 50
)

# With unified OS and custom filter
unified_rankings <- st_category_rankings(
  os = "unified",
  custom_fields_filter_id = "60746340241bc16eb8a65d76",
  custom_tags_mode = "include_unified_apps",
  chart_type = "topfreeapplications"
)
}

}
