% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{estimate_bias}
\alias{estimate_bias}
\title{Estimate Bias}
\usage{
estimate_bias(rho, R2, weights, sigma2)
}
\arguments{
\item{rho}{Correlation between the error in the weights and outcome}

\item{R2}{R2 measure for how much variation in the true weights is explained by the error term, must be bound on the range [0,1)}

\item{weights}{Vector of estimated weights}

\item{sigma2}{Estimated variance of the outcome (i.e., stats::var(Y) for obervational setting; stats::var(tau) for generalization setting)}
}
\value{
Estimated bias from omitting a confounder from weights
}
\description{
Returns the bias based on the different parameters in the bias decomposition
}
\examples{
set.seed(331)
Y = rnorm(1000)
weights = rlogis(1000)
weights = weights/mean(weights)
estimate_bias(rho = 0.5, R2 = 0.5, weights = weights, sigma2 = var(Y))
}
