% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_functions.R
\name{benchmark_survey}
\alias{benchmark_survey}
\title{Benchmark (for survey weights)}
\usage{
benchmark_survey(
  omit,
  formula,
  weights,
  pop_svy = NULL,
  sample_svy,
  Y,
  population_targets = NULL,
  weighting_method = "raking"
)
}
\arguments{
\item{omit}{Variable to benchmark}

\item{formula}{Raking formula}

\item{weights}{A vector, containing the estimated survey weights}

\item{pop_svy}{Survey object, containing the population the survey sample is being re-weighted to}

\item{sample_svy}{Survey object, containing the survey sample being re-weighted}

\item{Y}{outcome of interest}

\item{population_targets}{Population targets for the raking formula (optional, if not provided, will be generated from pop_svy)}

\item{weighting_method}{Weighting method (default to raking)}
}
\value{
Benchmarking results for a variable (or subset of variables)
}
\description{
Returns benchmarking results for survey weighting
}
\examples{
data(poll.data)
poll_srs <- survey::svydesign(ids = ~ 1, data = poll.data)
pop_targets = c(1, 0.212, 0.264, 0.236, 0.310, 
                0.114, 0.360, 0.528, 0.114, 
                0.021, 0.034, 0.805, 
                0.266, 0.075, 0.312, 0.349)
names(pop_targets) = c("(Intercept)",
                       "age_buckets36to50",
                       "age_buckets51to64",
                       "age_bucketsOver65",
                       "educHigh School or Less",
                       "educPost-grad",
                       "educSome college",
                       "genderWomen", 
                       "raceBlack",
                       "raceHispanic",
                       "raceOther",
                       "raceWhite", 
                       "pidIndependent", "pidOther", 
                       "pidRepublican", "bornagainYes")
#Set up raking formula:
formula_rake <- ~ age_buckets + educ + gender + race + pid + bornagain

#PERFORM RAKING:
model_rake <- survey::calibrate(
  design = poll_srs,
  formula = formula_rake,
  population = pop_targets,
  calfun = "raking",
  force = TRUE
)


rake_results <- survey::svydesign( ~ 1, data = poll.data, weights = stats::weights(model_rake))
#Estimate from raking results:
weights = stats::weights(rake_results) * nrow(model_rake)

unweighted_estimate = survey::svymean(~ Y, poll_srs, na.rm = TRUE)
weighted_estimate = survey::svymean(~ Y, model_rake, na.rm = TRUE)
benchmark_survey('educ', 
                 formula = formula_rake,
                 weights = weights,
                 population_targets = pop_targets,
                 sample_svy = poll_srs,
                 Y = poll.data$Y)
 
}
