% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_change_plot.R
\name{est_change_plot}
\alias{est_change_plot}
\alias{est_change_gcd_plot}
\title{Plots of Case Influence on
Parameter Estimates}
\usage{
est_change_plot(
  change,
  parameters,
  cutoff_change = NULL,
  largest_change = 1,
  title = TRUE,
  point_aes = list(),
  vline_aes = list(),
  hline_aes = list(),
  cutoff_line_aes = list(),
  case_label_aes = list(),
  wrap_aes = list()
)

est_change_gcd_plot(
  change,
  parameters,
  cutoff_gcd = NULL,
  largest_gcd = 1,
  cutoff_change = NULL,
  largest_change = 1,
  title = TRUE,
  point_aes = list(),
  hline_aes = list(),
  cutoff_line_aes = list(),
  case_label_aes = list(),
  wrap_aes = list()
)
}
\arguments{
\item{change}{The output from
\code{\link[=est_change]{est_change()}}, \code{\link[=est_change_raw]{est_change_raw()}},
\code{\link[=est_change_approx]{est_change_approx()}}, or
\code{\link[=est_change_raw_approx]{est_change_raw_approx()}}.}

\item{parameters}{If it is
a character vector, it
specifies the selected parameters.
Each parameter is named as in
\code{lavaan} syntax, e.g., \code{x ~ y} or \code{x ~~ y}, as appeared in the columns
\code{lhs}, \code{op}, and \code{rhs} in the output
of \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
Supports specifying an operator to
select all parameters with this
operators: \code{~}, \verb{~~}, \verb{=~}, and \code{~1}.
This vector can contain both
parameter names and operators.
If it is a numeric vector, it
specifies the columns to be used.
If omitted or \code{NULL},
the default, changes on all
parameters in \code{change}. will be used.}

\item{cutoff_change}{Cases with
absolute changes larger than this
value will be labeled. Default is
\code{NULL}. If \code{NULL}, no cutoff line
will be drawn.}

\item{largest_change}{The number of
cases with the largest absolute
changes to be labelled. Default is
\enumerate{
\item If not an integer, it will be
rounded to the nearest integer.
}}

\item{title}{If \code{TRUE}, the default,
a default title will be added to
the plot. If it is a string, it will
be used as the title. If \code{FALSE},
no title will be added to the plot.}

\item{point_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} to modify how
to draw the points. Default is
\code{list()} and internal default
settings will be used.}

\item{vline_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} to modify how
to draw the line for each case
in the index plot by
\code{\link[=est_change_plot]{est_change_plot()}}. Default is
\code{list()} and internal default
settings will be used.}

\item{hline_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}} to modify how
to draw the horizontal line for zero
case influence. Default is \code{list()}
and internal default settings will be
used.}

\item{cutoff_line_aes}{A named list
of arguments to be passed to
\code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}} in
\code{\link[=est_change_plot]{est_change_plot()}} or
\code{\link[ggplot2:geom_abline]{ggplot2::geom_vline()}} in
\code{\link[=est_change_gcd_plot]{est_change_gcd_plot()}} to modify how
to draw the line for user cutoff
value (\code{cutoff_change} or
\code{cutoff_gcd}). Default is \code{list()}
and internal default settings will be
used.}

\item{case_label_aes}{A named list of
arguments to be passed to
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}} to
modify how to draw the labels for
cases marked (based on
\code{cutoff_change}, \code{cutoff_gcd},
\code{largest_change}, or \code{largest_gcd}).
Default is \code{list()} and internal
default settings will be used.}

\item{wrap_aes}{A named list of
arguments to be passed to
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} to modify how
the plots are organized. Default is
\code{list()} and internal default
settings will be used.}

\item{cutoff_gcd}{Cases with
generalized Cook's distance or
approximate generalized Cook's
distance larger than this value will
be labeled. Default is \code{NULL}. If
\code{NULL}, no cutoff line will be drawn.}

\item{largest_gcd}{The number of
cases with the largest generalized
Cook's distance or approximate
generalized Cook's distance to be
labelled. Default is 1. If not an
integer, it will be rounded to the
nearest integer.}
}
\value{
A \code{ggplot2} plot. Plotted by
default. If assigned to a variable or
called inside a function, it will not
be plotted. Use \code{\link[=plot]{plot()}} to plot it.
}
\description{
Gets the output of
functions such as \code{\link[=est_change]{est_change()}} and
\code{\link[=est_change_approx]{est_change_approx()}} and plots case
influence on selected parameters.
}
\details{
The output of
\code{\link[=est_change]{est_change()}}, \code{\link[=est_change_raw]{est_change_raw()}},
\code{\link[=est_change_approx]{est_change_approx()}}, and
\code{\link[=est_change_raw_approx]{est_change_raw_approx()}} is simply a
matrix. Therefore, these functions
will work for any matrix provided.
Row number will be used on the x-axis
if applicable. However, case
identification values will be used
for labeling individual cases if they
are stored as row names.

The default settings for the plots
should be good enough for diagnostic
purpose. If so desired, users can
use the \verb{*_aes} arguments to nearly
fully customize all the major
elements of the plots, as they would
do for building a \code{ggplot2} plot.
}
\section{Functions}{
\itemize{
\item \code{est_change_plot()}: Index
plot of case influence on parameters.

\item \code{est_change_gcd_plot()}: Plot case
influence on parameter estimates
against generalized Cook's distance.

}}
\examples{

library(lavaan)

# A path model

dat <- pa_dat
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# Compute approximate case influence on parameters estimates
out <- est_change_approx(fit)

# Plot case influence for all regression coefficients
est_change_plot(out,
                parameters = "~",
                largest_change = 2)

# Plot case influence against approximated gCD for all
# regression coefficients
# Label top 5 cases with largest approximated gCD
est_change_gcd_plot(out,
                    parameters = "~",
                    largest_gcd = 5)

# Customize elements in a plot.
# For example, change the color and shape of the points.

est_change_plot(out,
                parameters = "~",
                largest_change = 2,
                point_aes = list(shape = 5,
                                 color = "red"))

}
\references{
Pek, J., & MacCallum, R.
(2011). Sensitivity analysis in
structural equation models: Cases
and their influence. \emph{Multivariate
Behavioral Research, 46}(2),
202-228.
doi:10.1080/00273171.2011.561068
}
\seealso{
\code{\link[=est_change]{est_change()}},
\code{\link[=est_change_raw]{est_change_raw()}},
\code{\link[=est_change_approx]{est_change_approx()}}, and
\code{\link[=est_change_raw_approx]{est_change_raw_approx()}}.
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}.
}
